DECLARE SUB lingua2 ()
DECLARE SUB logo ()
'       SUB examples()
' pgm sc300  : Interface - Dialogue  PC <--> GTR300 - controller
'
'
'      GTR 300 software rev. BA 2.00 + up; 30.09.88
'      sc3mini   'BB'   25.10.88 j.e
'      sc300     'BB'   25.10.88 j.e
'      sc3mini   'BC'   29.09.89 j.e
'      sc300     'BC'   19.10.89 j.e
'      sc9000   V 1.20  28.02.91 j.e  COLOR, TIMER, CUR1+2, bloc+summa new; without pc-sel
'      sc300     'BD'   28.02.91 j.e
'              rev.
'
'


main:               'programm starts here
	logo                                              'first screen : logo
	GOSUB lingua                                      'select language
	GOSUB config                                      'PC & interface configuration;

mainr:                                            'preset
	DIM par%(nrc% + 4, 80)                            'array with parameter & values
	DIM par$(80)                                      'array with comment to parameters and values
	DIM nam$(nrc% + 4)                                'array with channel names
	DIM parp%(18, 5)                                  'array with parameter page
	DIM parv%(18, 5)                                  'array with values page
	DIM sctxt$(15)                                    'array with flag-text for parameter

	GOSUB arrayset                                    'clear array par%( , ); set default numbers
	GOSUB tablec                                      'set table with comment for parameters and values
	GOSUB interfaceset                                'set interface number 1 or 2
	GOSUB registerset                                 'set register with default channel numbers
	GOSUB paraset                                     'set table tabpara, data <-- param. text

mainerr:                                          'return label on interface error
	GOSUB keyset                                      'set function-keys  level 1

mainloop:                                         'loop for cyclic display and key-control
	GOSUB fkey1                                       'test function-keys level 1
	GOSUB fkey9                                       'test function-key9 level 1
						'switch level 1 --> level 2

	GOSUB scloop                                      'cyclic dialog on interface bus set

	ON scflgk% GOSUB scline, scarray, parameter, bargraph

	GOTO mainloop                                     'end of loop





config:             'configuration interface
      CLS
      LOCATE 14, 1: COLOR 7, 1
      IF (lingu% = 0) THEN
	PRINT "   Schnittstellentyp :   com1   Eingabe '1'"
	PRINT "                         com2   Eingabe '2'"
	PRINT
	PRINT "         Eingabe  :";
      ELSE
	PRINT "      serial port :  com1   type `1`"
	PRINT "                     com2   type `2`"
	PRINT
	PRINT "           input  :";
      END IF

confi4:
      LOCATE 17, 29: PRINT "     "
      LOCATE 17, 29: aaa$ = INKEY$
      IF (aaa$ = "") THEN GOTO confi4
      comnr% = VAL(aaa$): PRINT aaa$;
      IF ((comnr% < 1) OR (comnr% > 2)) THEN GOTO confi4
      IF (comnr% <> 2) THEN comnr% = 1
      LOCATE 20, 1
      IF (lingu% = 0) THEN
	PRINT "   Zahl der angeschlossenen Gerte ( 31 max)"
	INPUT "         Eingabe  :         ", cmax%
      ELSE
	PRINT "     number of used controllers (31 max)"
	INPUT "      type number :         ", cmax%
      END IF
      IF (cmax% < 1) THEN cmax% = 1
      IF (cmax% > 31) THEN cmax% = 31
      nrc% = 4 * cmax%:                                   'test number of channels

     timstop! = TIMER + 2
     WHILE (TIMER <= timstop!)                            'delay for display 2 sec
     WEND
    RETURN



arrayset:           'arrayset - clear array par%) ( , ); set number of channels
   FOR sci0% = 0 TO nrc% + 4
     FOR sci1% = 0 TO 48
	 par%(sci0%, sci1%) = 0:                          'clear array
     NEXT sci1%
     par%(sci0%, 1) = sci0%:                              'set channel number
   NEXT sci0%
  RETURN



interfaceset:       'set interface number 1 or 2
     CLOSE
     IF comnr% = 2 THEN
	 OPEN "com2:9600,n,8,1,DS" FOR RANDOM AS #1 LEN = 1096
	 scrts% = &H2FC
     ELSE
	 OPEN "com1:9600,n,8,1,DS" FOR RANDOM AS #1 LEN = 1096
	 scrts% = &H3FC
     END IF
     ON ERROR GOTO interr:                                'return-address on interface error
  RETURN


interr:             'reset interface error
     RESUME NEXT
     scflgk% = 0
     losch% = 0
     GOSUB keyset
     aa$ = INKEY$
     KEY ON
     GOTO mainerr


registerset:        'set register with default channel numbers
	scnmin% = 1: scnmax% = nrc%:                      'limits for channel numbers
	scakt% = nrc%:                                    'set first channel
	scanreg% = 1:                                     'used channel --> Screen
	scctst% = scnmin%:                                'start addr. cyclic data load
  RETURN


keyset:             'set function-keys level 1
   KEY OFF                                                'set text

   IF (lingu% = 0) THEN
      KEY 1, "zeilen": KEY 2, " feld": KEY 3, "param": KEY 4, "bargr"
      KEY 6, "rd fil": KEY 7, "wr fil": KEY 8, "konfig": KEY 10, "stopp"
   ELSE
      KEY 1, "lines": KEY 2, "array": KEY 3, "param": KEY 4, "bargr"
      KEY 6, "rd fil": KEY 7, "wr fil": KEY 8, "config": KEY 10, "stop"
   END IF
   KEY 5, "": KEY 9, ""
   
   KEY(1) ON: KEY(2) ON: KEY(3) ON: KEY(4) ON            'set keys on/off
   KEY(5) OFF: KEY(6) ON: KEY(7) ON: KEY(8) ON
   KEY(9) OFF: KEY(10) ON
   KEY(11) OFF: KEY(12) OFF: KEY(13) OFF: KEY(14) OFF
   KEY(15) OFF: KEY(16) OFF: KEY(17) OFF: KEY(18) OFF: KEY(19) OFF
   KEY ON
   CLS
  RETURN



fkey1:              'test function-keys level 1
   IF (scflgk% <> 0) THEN                                   'level 2
       KEY(10) OFF
       KEY 10, ""
   ELSE                                                     'level 1
       ON KEY(1) GOSUB scfl1                                '  "lines"
       ON KEY(2) GOSUB scfl2                                '  "array"
       ON KEY(3) GOSUB scfl3                                '  "param"
       ON KEY(4) GOSUB scfl4                                '  "bargr"
       ON KEY(6) GOSUB rdfil                                '  "rd fil"
       ON KEY(7) GOSUB wrfil                                '  "wr fil"
       ON KEY(8) GOSUB names                                '  "config"
       ON KEY(10) GOSUB scfl10                              '  "stop"
   END IF
  RETURN



fkey9:              'test function-key9 level 1
   ON KEY(9) GOSUB scfl9                                    '  "break"
   IF (scflgk% = 0 AND losch% = 0) THEN                     'level 1 & return to level1
      CLS
      LOCATE 9, 2
      losch% = 1
      IF (lingu% = 0) THEN
	PRINT "                  P r o g r a m m  a u s w  h l e n !!!"
      ELSE
	PRINT "                        S E L E C T  J O B ! ! !"
      END IF
   END IF
  RETURN



scfl1:              'subroutine f-key "lines" level 2
     scflgk% = 1                                            'level flag
     scxfl% = 0
     CLS                                                    'clear screen
     KEY OFF
     IF (lingu% = 0) THEN
       KEY 6, " nr +": KEY 7, " nr -": KEY 9, "zurck"
     ELSE
       KEY 6, "chan +": KEY 7, "chan -": KEY 9, "break"
     END IF
     KEY 1, "": KEY 2, "": KEY 3, "": KEY 4, "": KEY 5, "": KEY 8, "": KEY 10, ""
     KEY(1) OFF: KEY(2) OFF: KEY(3) OFF: KEY(4) OFF: KEY(5) OFF
     KEY(6) ON: KEY(7) ON: KEY(8) OFF: KEY(9) ON: KEY(10) OFF
     KEY ON
   RETURN



scfl2:              'subroutine f-key "array" level 2
     scflgk% = 2                                            'level flag
     scxfl% = 0
     CLS                                                    'clear screen
     KEY OFF
     IF (lingu% = 0) THEN
       KEY 6, " nr +": KEY 7, " nr -": KEY 9, "zurck"
     ELSE
       KEY 6, "chan +": KEY 7, "chan -": KEY 9, "break"
     END IF
     KEY 1, "": KEY 2, "": KEY 3, "": KEY 4, "": KEY 5, "": KEY 8, "": KEY 10, ""
     KEY(1) OFF: KEY(2) OFF: KEY(3) OFF: KEY(4) OFF: KEY(5) OFF
     KEY(6) ON: KEY(7) ON: KEY(8) OFF: KEY(9) ON: KEY(10) OFF
     KEY ON
   RETURN



scfl3:              'subroutine f-key "param" level 2
     scflgk% = 3
     scxfl% = 0                                             'clear refresh - flag
     scparafl% = 0                                          'set "first time"
     scparapg% = 1
     pa% = 0                                                'set page 1
     can% = 4 * pa% + 1                                     'set first channel on display
     lin% = 6                                               'set cursor first line
     row% = 69                                              'set cursor second row
     CLS                                                    'clear screen
     KEY OFF
     IF (lingu% = 0) THEN
       KEY 5, "s. -->": KEY 6, " nr +": KEY 7, " nr -": KEY 9, "zurck"
     ELSE
       KEY 5, "pg -->": KEY 6, "chan +": KEY 7, "chan -": KEY 9, "break"
     END IF
     KEY 1, "": KEY 2, "": KEY 3, "": KEY 4, "": KEY 8, "": KEY 10, ""
     KEY(1) OFF: KEY(2) OFF: KEY(3) OFF: KEY(4) OFF: KEY(5) ON
     KEY(6) ON: KEY(7) ON: KEY(9) ON: KEY(8) OFF: KEY(10) OFF
     KEY(11) ON: KEY(12) ON: KEY(13) ON: KEY(14) ON         'set cursor keys
     KEY ON
     RETURN



scfl4:              'subroutine f-key "bargr" level 2
     scflgk% = 4
     scbarfl% = 0
     scxfl% = 0                                             'clear refresh - flag
     CLS                                                    'clear screen
     KEY OFF
     IF (lingu% = 0) THEN
       KEY 6, " nr +": KEY 7, " nr -": KEY 9, "zurck"
     ELSE
       KEY 6, "chan +": KEY 7, "chan -": KEY 9, "break"
     END IF
     KEY 1, "": KEY 2, "": KEY 3, "": KEY 4, "": KEY 5, "": KEY 8, "": KEY 10, ""
     KEY(1) OFF: KEY(2) OFF: KEY(3) OFF: KEY(4) OFF: KEY(5) OFF
     KEY(6) ON: KEY(7) ON: KEY(8) OFF: KEY(9) ON: KEY(10) OFF
     KEY ON
     RETURN



scfl9:              'subroutine f-key "break" level 1/2
     CLS
     scflgk% = 0
     scxfl% = 0
     losch% = 0
     scconfl% = 0                                           'clear flag for exit "config"
     scparlop% = 0                                          'clear flag for exit "param"
     GOSUB keyset                                           'set function-keys level 1
     RETURN                                                 'return from array ?



scfl10:             'f-key "stop" & programm stop   level 1
     COLOR 7, 0, 0
     CLS
     scflgk% = 0
     LOCATE 9, 2
     PRINT "              *****************  STOP  ***************** ";
     timstop! = TIMER + 1
     WHILE (TIMER <= timstop!)                            'delay for display 3 sec
     WEND
     STOP



scloop:             'cyclic dialog on interface bus
		    '      flag in array par%( ,79)
			'job only if time distance between two jobs >= 0.4 sec
			'job cannot interrupt itsself (sclpflg%)
			'job 1: test "A" (altern. flag) = changed parameters out on bus, one ch.
			'job 2: test "?" ( ask-flag) = input parameters from bus, one channel
			'job 3: cyclic load = input parameters from bus, one channel
			'job 4: cyclic load = input values from bus, one controller=up to 4 chan.
			'job 5: test "D" (data-flag) = parameters in array par%( , )
			'job 6: test "0" (empty) = parameters not in array par%( , )

    IF (TIMER < timlpp!) THEN GOTO scloop12
    IF (sclpflg% = 1) THEN GOTO scloop12
    sclpflg% = 1
    timlpp! = TIMER + .4                           'delay for cyclic dialog >=0.35 sec


    scin$ = "": scout$ = "": sci8% = 0

    FOR sci78% = 0 TO 8                           'increment & test parameter out reg. next 9 channels
       scopreg% = scopreg% + 1
       IF (scopreg% < scnmin%) THEN scopreg% = scnmin%
       IF (scopreg% > scnmax%) THEN scopreg% = scnmin%

       IF (par%(scopreg%, 79) = 65) THEN GOTO scloop4:      'test: "A"
       IF (par%(scopreg%, 79) = 63) THEN                    'test: "?"
	   scin$ = "": scnreg% = scopreg%: scxfl% = 0
	   GOSUB scip                            'subroutine input parameter(scnreg%)
	   sclpflg% = 0
	   RETURN                                           '  to array par%(scnreg%, ); exit sub
       END IF
    NEXT sci78%
    GOTO scloop6                                            'no "A" or "?" - flag

scloop4:                                         '"A" - flag; changed parameters out
    GOSUB scop                                              'subroutine output parameter from
    IF (scnfreg% < scnmin%) THEN
	scnfreg% = scnmin%
    ELSE
	scnfreg% = scnfreg% + 4                             'increment by 4 & test value input reg.
    END IF
    IF (scnfreg% > scnmax%) THEN scnfreg% = scnmin%
    GOSUB sciw                                   'subroutine input values(scnfreg%)
    sclpflg% = 0
 RETURN                           ' array par%(scnreg%, ) & ask for values to bus

scloop6:                                         'input values or param., all channels on line
    IF (sccc% < 2) THEN                                     ' 2* input value, 1* input param.
	IF (scnfreg% < scnmin%) THEN scnfreg% = scnmin%: GOTO scloop10
	scnfreg% = scnfreg% + 4                             'increment by 4 & test value input reg.
	IF (scnfreg% > scnmax%) THEN scnfreg% = scnmin%
scloop10:
	GOSUB sciw                               'subroutine input values(scnfreg%)
	sccc% = sccc% + 1                        '  to array par%(scnfreg%, )
    ELSE
	sccc% = 0:                                          ' 1* input param.
	IF (scctst% < scnmin%) THEN scctst% = scnmin%: GOTO scloop11
	scctst% = scctst% + 1                               'increment & test parameter input reg.
	IF (scctst% > scnmax%) THEN scctst% = scnmin%
scloop11:                                                   'test : "D" or "0"
	IF ((par%(scctst%, 79) = 68) OR (par%(scctst%, 79) = 0)) THEN
	    scin$ = "": scnreg% = scctst%: scxfl% = 0
	    GOSUB scip                           'subroutine input param.(scctst%)
	END IF                                   '  to array par%(scnreg%, )
    END IF
    sclpflg% = 0
scloop12:
  RETURN




sciw:               'inputs values of channel(scnfreg%) from interface-bus
		    ' answer has values of one controller ( 4 chan)
		    ' address is the first channel of the modul; the sequence
		    ' is constantly the same as typing No key on controller

  scnfreg% = 4 * INT((scnfreg% - 1) * .25) + 1:             'first channel of a controller
  IF (par%(scnfreg%, 14) <= 0) THEN GOTO scip4:             'test channel allowed ?
  sco$ = STR$(par%(scnfreg%, 1))                            'question for values --> scout$
  scout$ = scout$ + "R" + RIGHT$("000" + RIGHT$(sco$, LEN(sco$) - 1), 3) + "NF?"
						'subroutine string scout$ to interface
  GOTO scip1

scip:               'input parameters of channel(scnreg%) from interface-bus
		    ' answer has parameters of one channel

    IF (par%(scnreg%, 1) = 0) THEN GOTO scip4:              'test chan. no set
    scout$ = STR$(par%(scnreg%, 1))
						'question for parameters --> scout$
    scout$ = "R" + RIGHT$("000" + RIGHT$(scout$, LEN(scout$) - 1), 3) + "NT?"

scip1:

  GOSUB scsub                                               'string scin$ from interf.
						'wait until time limit
    'LOCATE 10, 2: PRINT "scip: LEN(scin$), S, T, Q,scout$,scin$ :";
    'PRINT USING "###"; LEN(scin$); INSTR(1, scin$, "S"); INSTR(1, scin$, "T"); INSTR(65, scin$, "Q");
    'PRINT "  "; LEFT$(scout$, 7): PRINT scin$
						'test answ.: length
  IF (LEN(scin$) >= 220) THEN scin$ = MID$(scin$, 107, 115) 'answer to long
  IF (LEN(scin$) < 113) THEN GOTO scip4                     'answer to short

    scin$ = MID$(scin$, 9, 105):                            'cleanup answer

						'test answ.: place of testpattern "S","F","Q"
    IF (ASC(LEFT$(scin$, 1)) <> 83) THEN GOTO scip4
    IF (ASC(MID$(scin$, 105, 1)) <> 81) THEN GOTO scip4
    IF (ASC(MID$(scin$, 7, 1)) <> 84) THEN GOTO sciw2

						'test answ.: chan.no in answer = chan.no in question
    IF (VAL(MID$(scin$, 2, 3)) <> par%(scnreg%, 1)) THEN GOTO scip4

    scsum% = 0                                              'answer string: calculate summa of 92*ASCII
    FOR sci1% = 0 TO 91
	 scsum% = scsum% + ASC(MID$(scin$, sci1% + 9, 1))
    NEXT sci1%

						'test answ.: calculated summa = summa in answer
    IF (RIGHT$("0000" + HEX$(scsum%), 4) <> (MID$(scin$, 101, 4))) THEN GOTO scip4

					'parameters scin$ --> array  par%(scnreg%,1..46)

    FOR sci1% = 0 TO 22                                 'change 3*ASCII --> 1* signed integer( 1+15 bit)

	    sczw1% = 1024 * (31 AND (ASC(MID$(scin$, sci1% + sci1% + sci1% + 9, 1)) - 32))
	    sczw1% = sczw1% + 16 * (63 AND (ASC(MID$(scin$, sci1% + sci1% + sci1% + 10, 1)) - 32))
	    sczw1% = sczw1% + (15 AND (ASC(MID$(scin$, sci1% + sci1% + sci1% + 11, 1)) - 32))

	    IF (64 AND (ASC(MID$(scin$, sci1% + sci1% + sci1% + 9, 1)))) THEN
		sczw1% = sczw1% - 32768                 'sign is (32 and (asc()-32))  = 64 and asc()
	    END IF
	    par%(scnreg%, sci1% + 1) = sczw1%

    NEXT sci1%


    FOR sci1% = 0 TO 22                                 'change 1*ASCII --> 1* unsigned char ( 6 bit)

	    par%(scnreg%, sci1% + 24) = 63 AND (ASC(MID$(scin$, sci1% + 78, 1)) - 32)

    NEXT sci1%
   
    scdpfl% = par%(scnreg%, 62)                           'set decimal point to
       par%(scnreg%, 76) = 0                            ' par%( ,76) in 3 .. 0.position from right
    IF ((scdpfl% = 7) OR (scdpfl% = &H10)) THEN
       par%(scnreg%, 76) = 1
    ELSEIF (scdpfl% = &H12) THEN
       par%(scnreg%, 76) = par%(scnreg%, 27)
    END IF
   
    par%(scnreg%, 79) = 68                              'set "D" flag: parameters in array

    GOTO scip4


sciw2:

    IF (ASC(MID$(scin$, 7, 1)) <> 70) THEN GOTO scip4

	 IF (VAL(MID$(scin$, 2, 3)) <> par%(scnfreg%, 1)) THEN GOTO scip4

						'test answ.: chan.no in answer = chan.no in question
	 REM PRINT "sciw No phys, No log:";VAL(MID$(scin$,2,3));scnfreg%;par%(scnfreg%, 1);

	 scsum% = 0                                       'answer string: calculate summa of 92*ASCII
	 FOR sci1% = 0 TO 91
	     scsum% = scsum% + ASC(MID$(scin$, sci1% + 9, 1))
	 NEXT sci1%

						'test answ.: calculated summa = summa in answer
	 IF (RIGHT$("0000" + HEX$(scsum%), 4) <> (MID$(scin$, 101, 4))) THEN GOTO scip4

					'values scin$ --> array  par%(scnfreg%...scnfreg%+3,47..71)
					'answer has values of up to 4 channels

	 FOR sci1% = 0 TO 4                               'change 3*ASCII --> 1* signed integer( 1+15 bit)
	     FOR sci2% = 0 TO 3                           ' first to fourth channel
		 IF (par%(scnfreg% + sci2%, 14) <= 0) THEN GOTO sciw3  'no param. in array
		 asv$ = MID$(scin$, 12 * sci1% + 3 * sci2% + 9, 3)
		 sczw2% = 1024 * (31 AND (ASC(LEFT$(asv$, 1)) - 32))
		 sczw2% = sczw2% + 16 * (63 AND (ASC(MID$(asv$, 2, 1)) - 32))
		 sczw2% = sczw2% + (15 AND (ASC(RIGHT$(asv$, 1)) - 32))

		 IF ((64 AND (ASC(LEFT$(asv$, 1)))) <> 0) THEN
		    sczw2% = sczw2% - 32768             'sign is (32 and (asc()-32))  = 64 and asc()
		 END IF
		 par%(scnfreg% + sci2%, sci1% + 47) = sczw2%
sciw3:
	     NEXT sci2%
	 NEXT sci1%                                       'parameters are different for each channel


	 FOR sci1% = 0 TO 3                               'change 1*ASCII --> 1* unsigned char ( 6 bit)

	     par%(scnfreg%, sci1% + 52) = 63 AND (ASC(MID$(scin$, sci1% + sci1% + sci1% + sci1% + 69, 1)) - 32)
	     par%(scnfreg% + 1, sci1% + 52) = 63 AND (ASC(MID$(scin$, sci1% + sci1% + sci1% + sci1% + 70, 1)) - 32)
	     par%(scnfreg% + 2, sci1% + 52) = 63 AND (ASC(MID$(scin$, sci1% + sci1% + sci1% + sci1% + 71, 1)) - 32)
	     par%(scnfreg% + 3, sci1% + 52) = 63 AND (ASC(MID$(scin$, sci1% + sci1% + sci1% + sci1% + 72, 1)) - 32)

	 NEXT sci1%                                       'parameters are different for each channel

 
	 FOR sci1% = 0 TO 15                              'change 1*ASCII --> 1* unsigned char ( 6 bit)

	     par%(scnfreg%, sci1% + 56) = 63 AND (ASC(MID$(scin$, sci1% + 85, 1)) - 32)
	     par%(scnfreg% + 1, sci1% + 56) = par%(scnfreg%, sci1% + 56)
	     par%(scnfreg% + 2, sci1% + 56) = par%(scnfreg%, sci1% + 56)
	     par%(scnfreg% + 3, sci1% + 56) = par%(scnfreg%, sci1% + 56)

	 NEXT sci1%                                       'parameters are equal for each channel

	 'scin$ = ""                                       'delete answer string
scip4:
  RETURN



scop:               'output parameters of channel(scopreg%) to interface-bus
		    ' no answer (bus not used)

					'par%(scopreg%,1..46)  --> scout$
	 'LOCATE 10, 2: PRINT "1: scopreg%, W:"; par%(scopreg%, 1); par%(scopreg%, 2)

						'test chan.no in array set
	 IF (par%(scopreg%, 1) = 0) THEN GOTO scop4

						'test parameters loaded;  e.a. cycle time tc
	 IF (par%(scopreg%, 14) <= 0) THEN GOTO scop4:    'tc > 0 --> p. set

					'head & channel no --> scout$
	 scout$ = STR$(par%(scopreg%, 1))
	 scout$ = "S" + RIGHT$("000" + RIGHT$(scout$, LEN(scout$) - 1), 3) + "  T "
	 '  n-bl: scout$ = "S" + RIGHT$("000" + RIGHT$(scout$, LEN(scout$) - 1), 3) + "  N "


					'par%(scopreg%,1..23)  --> scout$

	 FOR sci1% = 1 TO 23                              'change  1* signed integer(1+15 bit) --> 3*ASCII

	    sczw% = par%(scopreg%, sci1%): sczw2% = 0
	    IF (par%(scopreg%, sci1%) < 0) THEN sczw2% = 32: sczw% = (32767 AND sczw%)
	    scout$ = scout$ + CHR$(32 + sczw2% + (31 AND INT(sczw% / 1024)))
	    scout$ = scout$ + CHR$(32 + (63 AND INT(sczw% / 16)))
	    scout$ = scout$ + CHR$(32 + (15 AND sczw%))

	 NEXT sci1%

					'par%(scopreg%,24..46)  --> scout$
	 FOR sci1% = 0 TO 22                              'change  1* unsigned char( 6 bit) --> 1*ASCII
	    scout$ = scout$ + CHR$(32 + (63 AND (par%(scopreg%, 24 + sci1%))))
	 NEXT sci1%

	     scsum% = 0                                   'calculate summa of 92*ASCII
	 FOR sci1% = 0 TO 91
	     scsum% = scsum% + ASC(MID$(scout$, sci1% + 9, 1))
	 NEXT sci1%
						' summa & end-pattern --> scout$
	 scout$ = scout$ + RIGHT$("0000" + HEX$(scsum%), 4) + "Q"
	
	 par%(scopreg%, 79) = 63:                         ' set "?" flag : param. out
						' test: parameter input next time
	
	 'LOCATE 14, 2: PRINT "scop2%: scout$"; scout$;
scop4:
   RETURN


scsub:              'subroutine scout$ transmit, scin$ receive, wait maxtimsc
    scloc% = LOC(1)
    IF (scloc% > 0) THEN scin$ = INPUT$(scloc%, #1)
    scoutl% = LEN(scout$)
    OUT scrts%, INP(scrts%) OR 2                            'set rts
    PRINT #1, scout$
    scsvo2$ = scsvo$: scsvo$ = scout$: scout$ = scsvo2$     'exchange scout$ with scsvo$
    scsvo2% = scsvn%: scsvn% = scnreg%: scnreg% = scsvo2%   'exchange scnreg% with scsvn%
    scsvo2% = scsvf%: scsvf% = scnfreg%: scnfreg% = scsvo2% 'exchange scnfreg% with scsvf%

    maxtimsc! = TIMER + .04                                 'set maxtimsc for ?transmit
    IF (scoutl% > 12) THEN maxtimsc! = maxtimsc! + .1       'set maxtimsc for bloctransmit
scsub4:
    scloc% = LOC(1)                                         'input LOC(1)*ASCII, decr. wait maxtimsc
    IF ((scoutl% <= scloc%) OR (TIMER >= maxtimsc!)) THEN   'test: end of output scout$: clr rts
      OUT scrts%, INP(scrts%) AND &HFD
    ELSE
      GOTO scsub4
    END IF

     'LOCATE 6, 2: PRINT "scout$ "; scout$;                 'test output --> bus
     'LOCATE 11, 2: PRINT "scin$  "; LEN(scin$); scin$;     'test input <--  bus

scsub6:
	'y% = CSRLIN
	'x% = POS(0)
	'LOCATE 23, 60: PRINT "              ";
	'LOCATE 23, 60: PRINT LEFT$(scout$, 7); 'test: show question,length of answer
	'LOCATE 23, 70: PRINT LEN(scin$);
	'LOCATE y%, x%
	'LOCATE 5,2:PRINT  "scout$ ";scout$;                   'test output --> bus
	'LOCATE 8,2:PRINT  "scin$  ";LEN(scin$);scin$;         'test input <--  bus
  RETURN





scline:             'display parameters and values for next 6 channels
		    ' make your own version by setting sc22% and calling sctabb
       LOCATE 1, 2                                          'change number of controller
       scrnd% = 2                                           'delta for incr/decr page
       ON KEY(6) GOSUB scanzinc                             '  "chan +"
       ON KEY(7) GOSUB scanzdec                             '  "chan -"
						  'test: data in par%
       GOSUB chanerr

       IF (scxfl% = 0) THEN scxfl% = 1
       LOCATE 3, 2
       sc22% = 1                                  'print channel numbers
       GOSUB sctabb                               'print line with par%-number, comment, 6 * param.
						  'line no = scanreg%; comment = par$(sc22%);
						  'param. are par%(scanreg...scanreg%+5,%sc22%)
       COLOR 7, 1
       PRINT " ------------------------------------------------------------------------------"
       PRINT "                                   "

       sc22% = 47                                 'print process values
       GOSUB sctabb
       sc22% = 2                                  ' print setpoint 1 and 2
       GOSUB sctabb
       sc22% = 3
       GOSUB sctabb
       sc22% = 5                                  ' print setpoint higher limit
       GOSUB sctabb
       PRINT "                                   "
       PRINT "                                   "
       FOR sc22% = 14 TO 19
	GOSUB sctabb                              ' print process parameter
       NEXT sc22%
       PRINT "                                   "
       sc22% = 38
       GOSUB sctabb                              ' outputs on ?
sclend:
   RETURN


sctabb:             '  subroutine print array for 6 channels  =f(sc22%)
	COLOR 7, 1
	sc29% = CSRLIN                                    'ask for line number
	PRINT sc22%;                                      'print line number
	LOCATE sc29%, 5
	COLOR 10, 1
	PRINT par$(sc22%);                                'print comment
	COLOR 7, 1
	LOCATE sc29%, 36
	PRINT "";
	FOR sc23% = 0 TO 5                                'print 6 * parameter or value
	   PRINT USING "#######"; par%(sc23% + scanreg%, sc22%);
	NEXT sc23%
	PRINT
  RETURN




scarray:            ' display all parameters and values for one controller

	LOCATE 1, 1
	scparlop% = 1                                       'set param loop
	scrnd% = 4                                          'delta for incr/decr page
	ON KEY(6) GOSUB scanzinc                            '  "chan +"
	ON KEY(7) GOSUB scanzdec                            '  "chan -"

	scaanreg% = 4 * INT(.25 * (scanreg% - 1)) + 1       ' first channel of one controller
	IF (TIMER > scparatim! + 8) THEN
	   scparatim! = TIMER: scxfl% = 0: scxs% = 0        ' refresh parameters
	END IF
       
	IF (scft% <> 0) THEN GOTO scarr3                    ' change parameters
	IF (scxs% <> 0) THEN GOTO scarr3                    ' timeout param. input
       
	IF (scxfl% <> 0) THEN GOTO scarr2                   ' refresh display
	scxfl% = 1

	COLOR 10, 1
	PRINT "  nr    SP 1  SP 2  SP L  SP H              rn L  rn H  AL L  AL H  Y SE  Y hd"
	COLOR 7, 1
	FOR sci99% = 0 TO 3
	   PRINT USING "####"; par%(scaanreg% + sci99%, 1);
	   PRINT " ";
	   FOR sci98% = 2 TO 13
	     PRINT USING "######"; par%(scaanreg% + sci99%, sci98%);
	   NEXT sci98%
	   PRINT
	NEXT sci99%

	PRINT "     "
	PRINT "     ";
	COLOR 10, 1
	PRINT "  tc  PbI PbII   ti   td dbnd Ydry Edry           CHAn PtYP unit dPnt YtYP";
	COLOR 7, 1
	FOR sci99% = 0 TO 3
	   PRINT "     ";
	   PRINT USING "####"; par%(scaanreg% + sci99%, 14);
	  FOR sci98% = 15 TO 28
	     PRINT USING "#####"; par%(scaanreg% + sci99%, sci98%);
	  NEXT sci98%
	  PRINT
	NEXT sci99%

	PRINT "     "
	PRINT "     ";
	IF (lingu% = 0) THEN
	  arrasc1$ = " Werte:": arrasc2$ = "Parameter ndern:"
	ELSE
	  arrasc1$ = "values:": arrasc2$ = "change parameter:"
	END IF
	COLOR 10, 1
	PRINT " opt dSE dir out  AL YAs dry         out oPt  rn  CJ   x   xw    y  aaus";
	LOCATE 15, 52: PRINT arrasc1$;
	COLOR 7, 1

	LOCATE 14, 1
	FOR sci99% = 0 TO 3
	  PRINT "     ";
	  FOR sci98% = 29 TO 36
	     PRINT USING "####"; par%(scaanreg% + sci99%, sci98%);
	  NEXT sci98%
	  PRINT
	NEXT sci99%
       
	LOCATE 14, 39
	FOR sci98% = 37 TO 41
	  PRINT USING "####"; par%(scaanreg%, sci98%);
	NEXT sci98%

	LOCATE 15, 43
	COLOR 10, 1
	PRINT "Ycon";
	LOCATE 16, 43
	COLOR 7, 1
	PRINT USING "####"; par%(scaanreg%, 42);

	LOCATE 18, 1
	PRINT "     "
	PRINT "     ";
	COLOR 10, 1
	PRINT "   opi aus flg  xt rel  ik  sw  br ser  hz  Ax  Bx FCx  Dx  Ex G/H rev "
	COLOR 7, 1
       
	LOCATE 21, 56: PRINT "ͻ"
	LOCATE 22, 56: PRINT "   Rxxx pn  yyyy   "
	LOCATE 23, 56: PRINT "ͼ";
	LOCATE 21, 24: PRINT arrasc2$;
	LOCATE 22, 24: PRINT " pn  = 02..46: parameter-no.";
	LOCATE 23, 24: PRINT " xxx = 001...; yyyy = 0000...";
	scaft% = 0: scxs% = 0
	scafp% = 0: scqst$ = ""
scarr2:                                 ' reentry for cyclic refresh
	COLOR 7, 1
	FOR sci99% = 0 TO 3
	  LOCATE sci99% + 14, 60
	  PRINT USING "####"; par%(scaanreg% + sci99%, 47);
	  LOCATE sci99% + 14, 64
	  FOR sci98% = 48 TO 50
	     REM PRINT  USING "#####";par%(scaanreg%+sci99%,sci98%);
	     PRINT " " + RIGHT$("0000" + HEX$(par%(scaanreg% + sci99%, sci98%)), 4);
	  NEXT sci98%
	NEXT sci99%

	LOCATE 20, 1
	   PRINT "       ";
	   FOR sci98% = 52 TO 53
	      REM PRINT  USING "####";par%(scaanreg%,sci98%);
	      PRINT "  " + RIGHT$("00" + HEX$(par%(scaanreg%, sci98%)), 2);
	   NEXT sci98%
	   PRINT "   " + CHR$(par%(scaanreg%, 79));         ' "D" flag
	   FOR sci98% = 56 TO 60
	      PRINT "  " + RIGHT$("00" + HEX$(par%(scaanreg%, sci98%)), 2);
	   NEXT sci98%
	   FOR sci98% = 68 TO 69
	      PRINT "  " + RIGHT$("00" + HEX$(par%(scaanreg%, sci98%)), 2);
	   NEXT sci98%
	   FOR sci98% = 61 TO 67
	      PRINT "  " + RIGHT$("00" + HEX$(par%(scaanreg%, sci98%)), 2);
	   NEXT sci98%
	   PRINT
	FOR sci99% = 1 TO 3
	     PRINT "         " + RIGHT$("00" + HEX$(par%(scaanreg% + sci99%, 52)), 2);
	     PRINT "  " + RIGHT$("00" + HEX$(par%(scaanreg% + sci99%, 53)), 2);
	     PRINT "   " + CHR$(par%(scaanreg% + sci99%, 79))
	NEXT sci99%

scarr3:               ' input of parameter value for a selectable channel
					

	scaim$ = INKEY$
	IF (scaim$ = "") THEN GOTO scarr6
       
	scaim$ = LEFT$(scaim$, 1)
       
	IF ((scaim$ = CHR$(13)) AND (scafp% >= 2)) THEN     ' end of param. input
	   dumm1% = ((scparn% > 0) AND (scparn% < 123))
	   dumm2% = ((VAL(scparc$) >= 2) AND (VAL(scparc$) <= 46))    ' check limits
	   dumm3% = ((VAL(scai$) >= -999) AND (VAL(scai$) <= 5000))
	   IF ((dumm1% AND dumm2% AND dumm3%) = 0) THEN
	       scnreg% = 1: scai$ = "": scaim$ = "": scparc$ = "": scparn% = 0
	       scafp% = 0: scqst$ = "": scaft% = 0: scxs% = 0         ' off limits
	       GOTO scarr6
	   END IF
	   FOR sarlook% = scnmin% TO scnmax%                'look for correct channel
	       IF (par%(sarlook%, 1) = scparn%) THEN
		  scparn% = sarlook%
		  GOTO scarr4
	       END IF
	   NEXT
	   scparn% = 999
scarr4:                                                     'not found
	   par%(scparn%, VAL(scparc$)) = VAL(scai$)
	   par%(scparn%, 79) = 65                           ' change parameter
	   scparatim! = TIMER
	   scafp% = 0: scqst$ = "": scaft% = 0:  scxfl% = 0: scxs% = 0: scai$ = ""
	END IF

	IF (scaim$ = CHR$(13)) THEN
	    IF (scafp% = 1) THEN                            ' input pn param. number
	       scparc$ = RIGHT$(scai$, 2)
	       scafp% = 2: scaft% = 0: scai$ = ""
	    END IF
	    IF (scafp% = 0) THEN                            ' input xxx channel number
	       scparn% = 100 * (ASC(MID$(scai$, 1, 1)) - 48)
	       scparn% = scparn% + 10 * (ASC(MID$(scai$, 2, 1)) - 48) + ASC(MID$(scai$, 3, 1)) - 48
	       scparatim! = TIMER: scafp% = 1: scaft% = 0: scai$ = ""
	    END IF
	END IF
       
	IF (scafp% = 0) THEN               'input channel number, single ASCII
	   IF ((scaim$ >= "0") AND (scaim$ <= "9")) THEN
	      scai$ = RIGHT$("000" + scai$ + scaim$, 3): scaft% = 1: scxs% = 1
	      GOTO scarr5
	   END IF
	END IF
       
	IF (scafp% = 1) THEN               'input parameter number, single ASCII
	   IF ((scaim$ >= "0") AND (scaim$ <= "9")) THEN
	      scai$ = RIGHT$("00" + scai$ + scaim$, 2): scaft% = 1
	      GOTO scarr5
	   END IF
	END IF


	IF (scafp% = 2) THEN               'input parameter value, single ASCII
	   IF (((scaim$ >= "0") AND (scaim$ <= "9")) OR (scaim$ = "-")) THEN
	      scai$ = RIGHT$("0000" + scai$ + scaim$, 4)
	      scaft% = 1: GOTO scarr5
	   END IF
	END IF

	GOTO scarr6
scarr5:                                    ' print changed values
	COLOR 8, 7: LOCATE 22, 61 + 4 * scafp%: PRINT scai$; : COLOR 7, 1
	scparatim! = TIMER: scxs% = 1

scarr6:
	LOCATE 17, 42: PRINT LEFT$(scout$, 7); 'test: show question,length of answer
	LOCATE 17, 51: PRINT LEN(scin$); "  ";
	'LOCATE 12,8 : PRINT scin$;LEN(scin$);  'test: show answer
scarr9:
    RETURN



scanzinc:           ' subroutine f-key "pg up" level 2, increments by scrnd% channels
    scxfl% = 0
    scbarfl% = 0
    scparafl% = 0
    IF (scanreg% < scnmax% - scrnd% + 1) THEN               ' test max number of channels
	scanreg% = scanreg% + scrnd%
    ELSE
	scanreg% = scnmin%
    END IF
    GOSUB scanzsub
  RETURN



scanzdec:           ' subroutine f-key "pg dwn" level 2, decrements by scrnd% channels
    scxfl% = 0
    scbarfl% = 0
    scparafl% = 0
    IF (scanreg% > scrnd%) THEN                             ' test min number of channels
	scanreg% = scanreg% - scrnd%
    ELSE
	scanreg% = scnmax% - scrnd% + 1
    END IF
    GOSUB scanzsub
  RETURN

scanzsub:           'subr. for scanzinc/dec set can%
    IF (scparapg% >= 2) THEN lin% = 7: row% = 55
    IF (scparapg% = 1) THEN lin% = 6: row% = 39
    can% = 4 * INT(.25 * (scanreg% - 1)) + 1                ' calculate first channel
  RETURN



scdp:               ' set decimal point
		    ' change number  into string  & add decimal point & sign
   scdps$ = STR$(scdpn%)                                    ' number  scdpn% in
   scdp2% = par%(scdpr%, 76)                                ' string  scdps$ out
   IF (scdp2% = 0) THEN GOTO scdpend                        ' channel scdpr% in
  
   scdps$ = STR$(ABS(scdpn%))
   scdpl% = LEN(scdps$)
   scdps$ = RIGHT$(scdps$, scdpl% - 1)
  
   scdpl% = scdpl% - scdp2% - 1
   IF (scdpl% < 1) THEN scdpl% = 1
   scdp2$ = RIGHT$("00000" + scdps$, 5)                               ' fill string up
   scdps$ = "." + RIGHT$(scdp2$, scdp2%)                    ' string right from dp
   scdp2$ = LEFT$(scdp2$, 5 - scdp2%)
   scdps$ = RIGHT$(scdp2$, scdpl%) + scdps$                 ' string left from dp
							    ' set sign
   IF (scdpn% < 0) THEN scdps$ = "-" + scdps$ ELSE scdps$ = " " + scdps$
scdpend:
   scdps$ = RIGHT$("     " + scdps$, 6)                     ' constant length
  RETURN

chanerr:            ' test parameter not in array
       COLOR 15, 1
       cerr% = 0                                                      'test channel 1
       IF (par%(scanreg%, 14) < 1) THEN cerr% = 1
       IF (par%(scanreg% + 1, 14) < 1) THEN cerr% = 1
'       IF (par%(scanreg% + 2, 14) < 1) THEN cerr% = 1                 'no failure with
'       IF (par%(scanreg% + 3, 14) < 1) THEN cerr% = 1                 'two channel controller
       IF (cerr% = 1) THEN
	  IF (lingu% = 0) THEN
	     PRINT " **********  Datenuebertragung nicht abgeschlossen oder gestoert  ***********";
	  ELSE
	     PRINT " **********  data transmission incomplete or incorrect  ****************";
	  END IF
       ELSE
	 PRINT SPC(78);
       END IF
       COLOR 7, 1
   RETURN



parameter:          'display parameters & values for 4 channels
		    ' change parameters
		    'subroutine f-key "param" level 1
	LOCATE 1, 2
	scrnd% = 4                                          'delta for incr/decr page
	CLS                                                 'first time clear screen
	scparlop% = 1
	scparapg% = 2
	GOSUB scpaginc                                      'set flags line,row,channel
	can% = 4 * INT(.25 * (scanreg% - 1)) + 1            ' calculate first channel of two controllers
	COLOR 7, 1
	ON KEY(5) GOSUB scpaginc                            '  "pg -->"
	ON KEY(6) GOSUB scanzinc                            '  "chan +"
	ON KEY(7) GOSUB scanzdec                            '  "chan -"

						  'second cursor bloc
	ON KEY(11) GOSUB curup                              'cursor up
	ON KEY(12) GOSUB curleft                            'cursor left
	ON KEY(13) GOSUB curight                            'cursor right
	ON KEY(14) GOSUB curdwn                             'cursor down
para1:
     inpu$ = ""
para2:                                            'lop until fkt ta "break"
     LOCATE lin%, row%
     inn$ = INKEY$                                'change ?
     IF (scparafl% = 0) THEN                      'refresh display new or refresh
	scansv% = can%
	ON (scparapg%) GOSUB chanpar, syspar      'page incr. or chan change: new page
	scparafl% = 1: scparatim! = TIMER         'reset refresh counter
	GOSUB curset
     ELSE
	 IF (TIMER > scparatim! + 8) THEN
	     scparafl% = 0                        ' refresh distance
	     LOCATE 2, 72
	     PRINT LEFT$(TIME$, 5);
	     LOCATE 1, 2
	     GOSUB chanerr                        ' set first "channel without parameters"
	     LOCATE lin%, row%
	     inpu$ = "": inpu% = 0
	 END IF
     END IF

     IF (inn$ = "") THEN GOTO para5                         'wait

     IF ((LEN(inn$) = 2) AND (ASC(LEFT$(inn$, 1)) = 0)) THEN
	inn$ = RIGHT$(inn$, 1)                               'check first cursor bloc
	IF (inn$ = "H") THEN
	   GOSUB curup                                       'cursor up
	ELSEIF (inn$ = "K") THEN GOSUB curleft               'cursor left
	ELSEIF (inn$ = "M") THEN GOSUB curight               'cursor right
	ELSEIF (inn$ = "P") THEN GOSUB curdwn                'cursor down
	END IF
	inn$ = ""                                            'clr input buffer
	GOSUB curset                                         'set value, wait
	scparatim! = TIMER
	GOTO para5
     END IF

para3:
     IF (inn$ <> CHR$(13)) THEN                             'input
	COLOR 8, 7
	IF ((scparapg% = 1) AND (lin% >= 17)) THEN          ' page 1: incr flag register from min to max
	   scflgsv% = scflgsv% + 1
	   IF (scflgsv% > parp%(lin% - 5, 3)) THEN scflgsv% = parp%(lin% - 5, 5)
	   inpu$ = sctxt$(parp%(lin% - 5, 4) + scflgsv%)
	ELSEIF (scparapg% = 2) THEN                         ' page 2: incr flag register from min to max
	   scflgsv% = scflgsv% + 1
	   IF (scflgsv% > parv%(lin% - 5, 3)) THEN scflgsv% = parv%(lin% - 5, 5)
	   inpu$ = sctxt$(parv%(lin% - 5, 4) + scflgsv%)
	ELSE
	   inpu$ = inpu$ + inn$                             ' page 1: input
	END IF
	LOCATE lin%, row%                                   'display input
	PRINT RIGHT$("        " + inpu$, 8);
	COLOR 7, 1
	GOTO para2
     ELSE                                                   ' <CR>: end of input
	IF (inpu$ = "") THEN GOSUB curdwn: GOTO para5        'cursor down without change
	inpu% = INSTR(1, inpu$, ".")

	IF (inpu% <> 0) THEN
	   inps3$ = LEFT$(inpu$, inpu% - 1)
	   inpt2% = LEN(inpu$)
	   inpu$ = inps3$ + RIGHT$(inpu$, inpt2% - inpu%)
	END IF
	inpu% = VAL(inpu$)

	IF (((scparapg% = 1) AND (lin% >= 17)) OR (scparapg% = 2)) THEN
	   inpu% = scflgsv%                                 'flag input
	ELSE                                                'parameter input
	   IF (inpu% < parp%(lin% - 5, 5)) THEN inpu% = parp%(lin% - 5, 5)'test lower limit
	   IF (inpu% > parp%(lin% - 5, 3)) THEN inpu% = parp%(lin% - 5, 3)'test higher limit
	END IF
	GOSUB curcalc                                       'calculate padr%
	IF (par%(can%, 14) > 0) THEN                        ' write only if parm. in array
	   par%(can%, padr%) = inpu%                        'change parameter
	   par%(can%, 79) = 65                              'set "A" - flag
	END IF
	GOSUB curset                                        'display input, calculate padr%
	GOSUB curclr                                        'display off
	 
	timstop! = TIMER + .1
	WHILE (TIMER <= timstop!)                           'delay for display clear 0.1 sec
	WEND
	GOSUB curdwn
	inpu$ = "": inpu% = 0                               'save end
     END IF
para5:
     GOSUB scloop                                 'cyclic dialog on interface bus set
     IF (scparlop% <> 0) THEN GOTO para2                    ' loop until fkt9 key
     CLS
     scflgk% = 0                                            'level 2-->1
     scxfl% = 0                                             'clear refresh - flag
     scparafl% = 0                                          'clear flg first time
     scparapg% = 0                                          'flg,page for "param"
     COLOR 7, 1                                             'reset color
     GOSUB keyset                                           'set fkeys level 1
   RETURN



chanpar:            ' display parameters
	scansv% = can%
	GOSUB header
       
	scdiff = 1: dimen$ = ""
	FOR sc28% = 1 TO 4
	    GOSUB scpartdp
	NEXT sc28%
       
	FOR sc28% = 5 TO 7
	    GOSUB scpart
	NEXT sc28%
      
	dimen$ = "s"
	FOR sc28% = 8 TO 10
	    GOSUB scpart
	NEXT sc28%
       
	dimen$ = ""
	FOR sc28% = 12 TO 15                                'set channel mode
	    GOSUB scpop                                     'set direction output
	NEXT sc28%                                          'set limit comparator
							    'set self tuning
	sc28% = 17
	GOSUB scpart                                        'set data flag
	LOCATE 23, 2: PRINT SPC(77);
	can% = scansv%
  RETURN

syspar:             ' display parameters & values
	scansv% = can%
	GOSUB header
       
	COLOR 7, 1
	FOR sc42% = 2 TO 4
	   LOCATE 5 + sc42%, 55
	   scsv3% = parv%(sc42%, 4) + par%(can%, parv%(sc42%, 1))
	   PRINT RIGHT$("    " + sctxt$(scsv3%), 8);
	NEXT sc42%
	scdiff = 1
	sc28% = 6
	GOSUB scpartdp                                      ' process variable
	scdiff = 1 / 16.384
	dimen$ = "%."
	sc28% = 7
	GOSUB scpart                                        ' deviation
	sc28% = 8
	GOSUB scpart                                        ' output
	COLOR 7, 1
	FOR sc23% = 0 TO 3
	   scsv3% = (par%(can% + sc23%, 53) AND 63)
	   LOCATE 16, 37 + sc23% * 10                              ' SP 1
	   IF (scsv3% AND 16) THEN scsv4% = 3 ELSE scsv4% = 2
	   PRINT RIGHT$("          " + sctxt$(scsv4%), 10);
	   LOCATE 17, 37 + sc23% * 10                              ' SP 2
	   IF (scsv3% AND 32) THEN scsv4% = 3 ELSE scsv4% = 2
	   PRINT RIGHT$("          " + sctxt$(scsv4%), 10);
	   LOCATE 18, 37 + sc23% * 10                              ' AL L
	   IF (scsv3% AND 8) THEN scsv4% = 14 ELSE scsv4% = 13
	   PRINT RIGHT$("          " + sctxt$(scsv4%), 10);
	   LOCATE 19, 37 + sc23% * 10                              ' AL H
	   IF (scsv3% AND 4) THEN scsv4% = 14 ELSE scsv4% = 13
	   PRINT RIGHT$("          " + sctxt$(scsv4%), 10);
	   LOCATE 21, 37 + sc23% * 10                              ' sensor error
	   IF (scsv3% AND 2) THEN scsv4% = 14 ELSE scsv4% = 13
	   PRINT RIGHT$("          " + sctxt$(scsv4%), 10);
	NEXT sc23%

	scsv3% = 13 + (1 AND par%(can%, 60))                 ' heating error
	LOCATE 22, 55: PRINT RIGHT$("          " + sctxt$(scsv3%), 8);
	COLOR 7, 1
	can% = scansv%
   RETURN


header:             ' subr set header
	LOCATE 2, 2
	datum$ = DATE$
	can% = 4 * INT(.25 * (scanreg% - 1)) + 1          ' calculate first channel of two controllers
       
	IF (lingu% = 0) THEN
	   scpa$ = "Gert      # ": scpb$ = "Regelkreis Name": scpc$ = "           Nummer"
	   datum$ = MID$(datum$, 4, 2) + "." + LEFT$(datum$, 2) + "." + RIGHT$(datum$, 4)
	ELSE
	   scpa$ = "controller       # ": scpb$ = "name of channel": scpc$ = "number of channel"
	END IF

	LOCATE 2, 2: PRINT scpa$; INT(.25 * (can% - 1)) + 1
	LOCATE 2, 55: PRINT datum$
	LOCATE 3, 2: PRINT scpb$;
	LOCATE 4, 2: PRINT scpc$;
	FOR sc41% = 0 TO 3
	  LOCATE 3, 39 + 10 * sc41%
	  PRINT RIGHT$("          " + nam$(can% + sc41%), 8);
	  LOCATE 4, 43 + 10 * sc41%
	  PRINT USING "####"; par%(can% + sc41%, 1);
	NEXT sc41%
	PRINT " -----------------------------------------------------------------------------"
	COLOR 10, 1
	IF (scparapg% = 1) THEN                   'parameters
	   FOR sc41% = 1 TO 17                    'set text lines
	      LOCATE sc41% + 5, 2
	      IF (parp%(sc41%, 1) = 0) THEN       'empty line
		 PRINT SPC(78);
	      ELSE                                'text
		 PRINT par$(parp%(sc41%, 1));
	      END IF
	   NEXT sc41%
	ELSE                                      'values
	   FOR sc41% = 1 TO 10                    'set text lines
	     LOCATE sc41% + 5, 2
	     IF (parv%(sc41%, 1) = 0) THEN
		PRINT SPC(78);                    'empty line
	     ELSE                                 'text
		PRINT par$(parv%(sc41%, 1));
	     END IF
	   NEXT sc41%

	   scpa$ = "output                  ": scpb$ = "high"
	   scpc$ = " low": scpd$ = "sensor error"
	   IF (lingu% = 0) THEN
	      scpa$ = "Ausgang                 ": scpb$ = " max"
	      scpc$ = " min": scpd$ = "Fhlerfehler"
	      LOCATE 18, 2: PRINT "Alarm                   "; scpc$;
	   ELSE
	      LOCATE 18, 2: PRINT "alarm                   "; scpc$;
	   END IF
	   LOCATE 16, 2: PRINT scpa$; "   I"
	   LOCATE 17, 25: PRINT "  II";
	   LOCATE 19, 25: PRINT scpb$;
	   LOCATE 21, 2: PRINT scpd$;
	   LOCATE 22, 2: PRINT par$(68);
	END IF

	COLOR 7, 1
   RETURN



scpart:             ' subroutine print data = f(sc28%)
	LOCATE 5 + sc28%, 37
	FOR sc23% = 0 TO 3                                'print 4 * parameter or value text
	    PRINT "    ";
	    IF (scparapg% = 2) THEN
	       PRINT USING "######"; INT(scdiff * par%(can% + sc23%, parv%(sc28%, 1)));
	    ELSE
	       PRINT USING "######"; INT(scdiff * par%(can% + sc23%, parp%(sc28%, 1)));
	    END IF
	NEXT sc23%
	PRINT " "; dimen$;             'scdiff: factor makes correct number base
  RETURN

scpop:              ' subroutine print text of modes
	COLOR 7, 1
	LOCATE 5 + sc28%, 37
	FOR sc23% = 0 TO 3                                'print 4 * parameter or value text
	    IF (scparapg% = 2) THEN
	       scsv3% = parv%(sc28%, 4) + par%(can% + sc23%, parv%(sc28%, 1))
	    ELSE
	       scsv3% = parp%(sc28%, 4) + par%(can% + sc23%, parp%(sc28%, 1))
	    END IF
	   PRINT RIGHT$("    " + sctxt$(scsv3%), 10);
	NEXT sc23%
  RETURN


scpartdp:           ' subroutine print data = f(sc28%) with decimal point
	LOCATE 5 + sc28%, 37
	FOR sc23% = 0 TO 3                                'print 4 * parameter or value text
	    scdpr% = can% + sc23%
	    PRINT "    ";
	    IF (scparapg% = 2) THEN
	       scdpn% = INT(scdiff * par%(can% + sc23%, parv%(sc28%, 1)))
	    ELSE
	       scdpn% = INT(scdiff * par%(can% + sc23%, parp%(sc28%, 1)))
	    END IF                     'scdiff: factor makes correct number base
	    GOSUB scdp                                     'set dp
	    PRINT scdps$;
	NEXT sc23%
  RETURN



scpaginc:           ' subr next page fkt key "pg -->"  level 2
   lin% = 7: row% = 55
   can% = 4 * INT(.25 * (scanreg% - 1)) + 1          ' calculate first channel
   IF (scparapg% >= 2) THEN
      lin% = 6: row% = 39                                   'incr. page until max
      scparapg% = 1
   ELSE
      scparapg% = 2
   END IF
   CLS                                                      ' new screen
   scparafl% = 0                                            ' new header
 RETURN

curleft:            ' move cursor left in param
			   ' change parameter, no interrupt
   scparatim! = TIMER      ' reset refresh timer
   GOSUB curclr                                   'clear last cursor position
   inpu$ = ""
   IF (scparapg% >= 2) THEN
      row% = 55                              'page two only one position
   ELSE
      IF (row% <= 39) THEN
	  row% = 69
	  can% = 4 * INT(.25 * (scanreg% - 1)) + 4        ' calculate last channel
      ELSE
	  row% = row% - 10: can% = can% - 1
      END IF
   END IF                                         'test left end & shift left
   GOSUB curset                                   'set cursor position
   RETURN

curight:            ' move cursor right in param
			   ' change parameter, no interrupt
   scparatim! = TIMER            ' reset refresh timer
   GOSUB curclr                                   'clear last cursor position
   inpu$ = ""
   IF (scparapg% >= 2) THEN
      row% = 55                                   'page two only one position
   ELSE
      IF (row% >= 69) THEN
	 row% = 39
	 can% = 4 * INT(.25 * (scanreg% - 1)) + 1            ' calculate first channel of two controllers
      ELSE
	 row% = row% + 10: can% = can% + 1
      END IF
   END IF                                         'test right end & shift right
   GOSUB curset                                   'calculate parameter address from cursor position & set cursor
   RETURN

curclr:             'clear cursor for param
   padr% = 0                            'clr flg
   GOTO curse

curset:             'calculate parameter address & set cursor for param
   padr% = 1
   GOSUB curcalc                 ' calculate addr in par%(,) from cursor position
   COLOR 8, 7                    'set color inverse
curse:
   IF (padr% = 0) THEN COLOR 7, 1     ' set back color : from curclr or addr not found
   LOCATE lin%, row%
   PRINT scpa$
   COLOR 7, 1
   LOCATE lin%, row% - 2
   PRINT "  ";
   RETURN


curcalc:           ' calculate addr in par%(,) from cursor position
   padr% = 0                            'default addr : cursor off
   IF (scparapg% = 2) THEN              'page 2
      padr% = parv%(lin% - 5, 1)                        'parameter address in par%
      scflgsv% = par%(can%, padr%)
      scsv3% = parv%(lin% - 5, 4) + scflgsv%            'offset + parameter
      scpa$ = sctxt$(scsv3%)                            'text for flag
   ELSE                                 'page 1
      padr% = parp%(lin% - 5, 1)
      scflgsv% = par%(can%, padr%)
      scsv3% = parp%(lin% - 5, 4) + scflgsv%            'offset + parameter
      scpa$ = sctxt$(scsv3%)                            'text
      IF ((lin% >= 6) AND (lin% < 10)) THEN             'number input --> text & dp
	   scdpr% = can%: scdpn% = par%(can%, padr%)
	   GOSUB scdp
	   scpa$ = RIGHT$("          " + scdps$, 8)
      END IF
      IF ((lin% >= 10) AND (lin% < 16)) THEN             'number input --> text
	   scpa$ = RIGHT$("          " + STR$(par%(can%, padr%)), 8)
      END IF
   END IF
   RETURN




bargraph:           'display bargraph for 8 channels
		    'subroutine f-key "bargr " level 1
	LOCATE 1, 2
	scrnd% = 4                                          'delta for incr/decr page
	ON KEY(6) GOSUB scanzinc                            '  "pg up"
	ON KEY(7) GOSUB scanzdec                            '  "pg dwn"
barg2:                                                  'loop until fkt ta "break"
	scaanreg% = 4 * INT(.25 * (scanreg% - 1)) + 1      ' calculate first channel of two controllers
	IF (scbarfl% <> 0) THEN GOTO barg4        ' first time:
	scbarfl% = 1                              '   display whole picture
	GOSUB graph                                         'basic display
barg4:                                            '   refresh values
	GOSUB timwx                                         'time & date & SP & X & SE
	GOSUB bar                                           'bar lines
	GOSUB scloop                            'cyclic dialog on interface bus set
	IF scflgk% <> 0 THEN GOTO barg2           'loop
	scbarfl% = 0
	COLOR 7, 1
   RETURN



graph:              'display coordinates & border & names
     CLS
     FOR bi% = 0 TO 7
	IF par%(scaanreg% + bi%, 14) > 0 THEN              'parameters in channel  (nc > 0)
	  LOCATE 2, (2 + 10 * bi%)                          'channel names
	  PRINT nam$(scaanreg% + bi%)
	END IF
	LOCATE 3, (2 + 10 * bi%)                            'channel number all times
	PRINT " nr";
	PRINT USING "#####"; par%(bi% + scaanreg%, 1)
     NEXT bi%
     COLOR 7, 1
     FOR bk% = 2 TO 72 STEP 10
	  LOCATE 4, bk%                                     'border
	  PRINT "Ŀ"
	  FOR bi% = 5 TO 18
	     LOCATE bi%, bk%
	     PRINT "       "
	  NEXT bi%
	  LOCATE 19, bk%
	  PRINT ""
     NEXT bk%
     COLOR 7, 1
   
     FOR bk% = 5 TO 75 STEP 10                              'coordinates
	FOR bi% = 6 TO 18
	   LOCATE bi%, bk%
	   PRINT ""
	NEXT bi%                                            'scales
	LOCATE 12, bk% - 1
	PRINT "0  "
	LOCATE 5, bk% - 1
	PRINT "%  xw"
	LOCATE 6, bk% - 2
	PRINT "+6"
	LOCATE 9, bk% - 2
	PRINT "+3"
	LOCATE 15, bk% - 2
	PRINT "-3"
	LOCATE 18, bk% - 2
	PRINT "-6"
     NEXT bk%
  RETURN



timwx:      ' display date & time & process variable & setpoint & self tune & sensor error
   
    datum$ = DATE$
    IF (lingu% = 0) THEN
       datum$ = MID$(datum$, 4, 2) + "." + LEFT$(datum$, 2) + "." + RIGHT$(datum$, 4)
    END IF

    LOCATE 1, 55
    PRINT datum$                                             'date & time
    LOCATE 1, 73
    PRINT LEFT$(TIME$, 5)
    FOR bi% = 0 TO 7                              'next eight channels
	VB% = par%(scaanreg% + bi%, 62)                     'ask variante "B.."
	IF par%(scaanreg% + bi%, 14) = 0 THEN
	    LOCATE 2, 2 + 10 * bi%
	    PRINT "         ";
	    LOCATE 20, 2 + 10 * bi%
	    PRINT "         ";
	    LOCATE 21, 2 + 10 * bi%
	    PRINT "         ";
	    GOTO timwxend
	END IF
	LOCATE 2, (2 + 10 * bi%)                            'channel names
	PRINT nam$(scaanreg% + bi%)
	scdpr% = scaanreg% + bi%: scdpn% = par%(scaanreg% + bi%, 47)
	GOSUB scdp                                          'set dp
	LOCATE 20, 2 + 10 * bi%                             'parameters in channel  (nc > 0)
	PRINT "X  "; scdps$;                                'process variable

	LOCATE 21, 2 + 10 * bi%
	IF (par%(scaanreg% + bi%, 60) AND 2) THEN           'test SP 1 or SP 2
	      PRINT "SP2";                                  'setpoint 2
	      scdpn% = par%(scaanreg% + bi%, 3)
	ELSE
	      PRINT "SP1";                                  'setpoint 1
	      scdpn% = par%(scaanreg% + bi%, 2)
	END IF
	GOSUB scdp                                          'set dp
	PRINT scdps$;

	LOCATE 22, 2 + 10 * bi%
	IF (par%(scaanreg% + bi%, 52) AND 15) THEN          'runs self tuning
	      COLOR 20
	      IF (lingu% <> 0) THEN PRINT "TUNING ";  ELSE PRINT "OPT ein "
	      COLOR 7, 1                                    'self tuning
	ELSE
	      PRINT "        "
	END IF

	LOCATE 23, 7 + 10 * bi%
	COLOR 10, 1
	scsv43% = par%(scaanreg% + bi%, 53)
	IF (scsv43% AND 2) THEN
	   PRINT "SER ";                                    'sensor error?
	ELSEIF (scsv43% AND 4) THEN PRINT "ALH ";           'alarm high?
	ELSEIF (scsv43% AND 8) THEN PRINT "ALL ";           'alarm low?
	ELSE PRINT "    ";                                  ' ok
	END IF
	COLOR 7, 1
timwxend:
    NEXT bi%
  RETURN



bar:                'calculate & display bargraph
  
    FOR bi% = 0 TO 7                              'next eight channels
	barstep% = FIX(par%(scaanreg% + bi%, 48) / 163.84)  'deviation xw in %
	IF (par%(scaanreg% + bi%, 14) = 0) THEN barstep% = 0   ' no parameters
	IF barstep% > 6 THEN
						  ' 6..bar..
	    FOR bk% = 1 TO 6
		LOCATE 12 - bk%, 7 + 10 * bi%               'full bar up
		COLOR 4: PRINT "": COLOR 7
		LOCATE 12 + bk%, 7 + 10 * bi%               'clear bar down
		PRINT " "
	    NEXT bk%
      
	ELSEIF barstep% < -6 THEN
						  ' ..bar..-6
	    FOR bk% = 1 TO 6
		LOCATE 12 + bk%, 7 + 10 * bi%               'full bar down
		COLOR 4: PRINT "": COLOR 7
		LOCATE 12 - bk%, 7 + 10 * bi%               'clear bar up
		PRINT " "
	    NEXT bk%
	  
	ELSEIF barstep% < 0 THEN
						  ' -6..bar..0
	    bk% = barstep%
	    LOCATE 12 - bk%, 7 + 10 * bi%
	    COLOR 4: PRINT "": COLOR 7                     'half bar down

	    FOR bk% = (barstep% + 1) TO -1                  'full bar down
		LOCATE 12 - bk%, 7 + 10 * bi%
		COLOR 4: PRINT "": COLOR 7
	    NEXT bk%
     
	    FOR bk% = -6 TO (barstep% - 1)                  'clear bar up
		LOCATE 12 - bk%, 7 + 10 * bi%
		PRINT " "
	    NEXT bk%
	    FOR bk% = 1 TO 6
		LOCATE 12 - bk%, 7 + 10 * bi%: PRINT " "
	    NEXT bk%

	ELSEIF barstep% > 0 THEN
						  '0..bar..6
	    FOR bk% = 1 TO (barstep% - 1)                   'full bar up
		LOCATE 12 - bk%, 7 + 10 * bi%: COLOR 4: PRINT ""
	    NEXT bk%
	     
	    LOCATE 12 - barstep%, 7 + 10 * bi%
	    COLOR 4: PRINT "": COLOR 7                     'half bar up
	    FOR bk% = (barstep% + 1) TO 6
		LOCATE 12 - bk%, 7 + 10 * bi%: PRINT " "
	    NEXT bk%

	    FOR bk% = -6 TO -1
		LOCATE 12 - bk%, 7 + 10 * bi%: PRINT " "    'clear bar down
	    NEXT bk%
	END IF
						  ' set half bar
	LOCATE 12, 7 + 10 * bi%
	IF barstep% > 0 THEN
		COLOR 4: PRINT "": COLOR 7                 ' bar upper half
	ELSEIF barstep% < 0 THEN
		COLOR 4: PRINT "": COLOR 7                 'bar lower half
	ELSE
		FOR bk% = -6 TO -1                          'clear bar down
		     LOCATE 12 - bk%, 7 + 10 * bi%: PRINT " "
		NEXT bk%
	       
		FOR bk% = 1 TO 6
		     LOCATE 12 - bk%, 7 + 10 * bi%          'clear bar up
		     PRINT " "
		NEXT bk%

		LOCATE 12, 7 + 10 * bi%
		COLOR 10: PRINT "": COLOR 7
	END IF
    NEXT bi%
  RETURN



rdfil:              'function key "rd fil" level 1
		' read a file with parameters & names for one controller (4 chan.) from source
  CLS                                             'are you shure, ask filename
  LOCATE 3, 2
  set$ = "  zone  "
  IF (lingu% = 0) THEN                            'ask again
      PRINT "          Die Parameter eines Gertes werden berschrieben"
      INPUT "           durch  file.par .                        (j/n) :   ", in$
      IF ((in$ <> "j") AND (in$ <> "J") AND (in$ <> "y") AND (in$ <> "Y")) THEN GOTO rdfil9
rdfil1:
      LOCATE 7, 2
      INPUT "          Gertenummer eingeben           ( s.a.'konfig') :   ", inpnr%
      IF (inpnr% > nrc% / 4 + 1) THEN LOCATE 10, 2: PRINT SPC(60); : GOTO rdfil1
      IF (inpnr% < 1) THEN inpnr% = 1                       'default number = 1
      PRINT : PRINT
      INPUT "          Pfad/Filename eingeben             (ohne  .par) :   ", inpu$
      PRINT : PRINT                                         'parameter to bus
      INPUT "          Parameter an Gert ausgeben?              (j/n) :   ", inn$

  ELSE
      PRINT "          parameters of one controller will be destroyed"
      INPUT "           and loaded from   file.par .          (y/n) :   ", in$
      IF ((in$ <> "j") AND (in$ <> "J") AND (in$ <> "y") AND (in$ <> "Y")) THEN GOTO rdfil9
rdfil2:
      LOCATE 7, 2
      INPUT "          type number of controller     (see 'config') :   ", inpnr%
      IF (inpnr% > nrc% / 4 + 1) THEN LOCATE 10, 2: PRINT SPC(60); : GOTO rdfil2
      IF (inpnr% < 1) THEN inpnr% = 1                       'default number = 1
      PRINT : PRINT
      INPUT "          type path/filename            (without .par) :   ", inpu$
      PRINT : PRINT
      INPUT "          transmit parameters to controller     (y/n) :   ", inn$
  END IF

  IF ((inn$ <> "j") AND (inn$ <> "J") AND (inn$ <> "y") AND (inn$ <> "Y")) THEN inn$ = ""
  IF (inpu$ = "") THEN inpu$ = "c:data.par" ELSE inpu$ = inpu$ + ".par"
  CLOSE #5: OPEN inpu$ FOR RANDOM AS #5 LEN = 450
  FIELD #5, 100 AS parm1$, 100 AS parm2$, 100 AS parm3$, 100 AS parm4$
  
    sc31% = 1 + 4 * (inpnr% - 1)
    GET #5, 1
    pa$ = parm1$
    GOSUB rdsub
    GET #5, 2
    pa$ = parm2$
    GOSUB rdsub
    GET #5, 3
    pa$ = parm3$
    GOSUB rdsub
    GET #5, 4
    pa$ = parm4$
    GOSUB rdsub
    CLOSE #5
rdfil9:
    CLS
    GOSUB keyset
  RETURN



rdsub:              'read name  & parameters for one channel; delete values; set flag

    inm$ = LEFT$(pa$, 8)                                   'read name
    LOCATE 19, 20: PRINT " name :"; inm$;
    in$ = MID$(pa$, 9, 2)
    in% = CVI(in$)
    LOCATE 19, 40: PRINT " nr :"; ; in%; in$;
    in% = par%(sc31%, 1)
    IF ((in% < 1) OR (in% > 999)) THEN                   'test channel number
	par%(sc31%, 1) = sc31%                            'set default
    END IF
    IF (inm$ = "") THEN inm$ = set$ + HEX$(in%)
    nam$(sc31%) = inm$                                    'write name
    IF (lingu% = 0) THEN
	  LOCATE 16, 2
	  PRINT "                             lese Regelkreis              :   "; sc31%
    ELSE
	  LOCATE 16, 2
	  PRINT "                            reading channel            :   "; sc31%
    END IF
    LOCATE 20, 2
    FOR sc32% = 3 TO 47
	 in$ = MID$(pa$, 5 + 2 * (sc32%), 2)
	 in% = CVI(in$)
	 par%(sc31%, sc32% - 1) = in%                     'set parameters without number
'         PRINT " "; in%;
    NEXT sc32%
    IF (inn$ = "") THEN
	par%(sc31%, 79) = 68                              'set "D" flag
    ELSE
	par%(sc31%, 79) = 65                              'set "A" flag, loaded parameters will be
    END IF                                                '   written to controllers !!!!!!!!!

    IF (par%(sc31%, 14) > 0) THEN GOTO rdfil4             'no parameters ?
    par%(sc31%, 79) = 0                                   'clear flag
rdfil4:
    FOR sc32% = 47 TO 78
	par%(sc31%, sc32%) = 0                            'clear values
    NEXT sc32%
    sc31% = sc31% + 1
    ist% = 0
    timstop! = TIMER + .3
    WHILE (TIMER <= timstop!)                           'delay for next bloc 0.3 sec
    WEND
  RETURN



wrfil:              'function key "wr fil" level 1
		' write a file with parameters & names of one controller (4 chan.) into source
  CLS                                              'are you shure, ask filename
  LOCATE 3, 2
  set$ = "  zone  "

  IF (lingu% = 0) THEN                            'ask again
      PRINT "          Die Parameter eines Gertes werden gespeichert,"
      INPUT "           es wird ein   file.par erzeugt.        (j/n) :   ", in$
      IF ((in$ <> "j") AND (in$ <> "J") AND (in$ <> "y") AND (in$ <> "Y")) THEN GOTO wrfil9
wrfil1:
      LOCATE 7, 2
      INPUT "          Gertenummer eingeben         ( s.a.'konfig') :   ", inpnr%
      IF (inpnr% > nrc% / 4 + 1) THEN LOCATE 10, 2: PRINT SPC(60); : GOTO wrfil1
      IF (inpnr% < 1) THEN inpnr% = 1                       'default number = 1
      PRINT : PRINT
      INPUT "          Pfad/Filename eingeben           (ohne  .par) :   ", inpu$

  ELSE
      PRINT "          parameters of one controller are written"
      INPUT "           into  file.par                   (y/n) :   ", in$
      IF ((in$ <> "j") AND (in$ <> "J") AND (in$ <> "y") AND (in$ <> "Y")) THEN GOTO wrfil9
wrfil2:
      LOCATE 7, 2
      INPUT "          type number of controller (see'config') :   ", inpnr%
      IF (inpnr% > nrc% / 4 + 1) THEN LOCATE 10, 2: PRINT SPC(60); : GOTO wrfil2
      IF (inpnr% < 1) THEN inpnr% = 1                       'default number = 1
      PRINT : PRINT
      INPUT "          type path/filename       (without .par) :   ", inpu$
  END IF                                                    'default path on c:/

  IF (inpu$ = "") THEN inpu$ = "c:data.par" ELSE inpu$ = inpu$ + ".par"
  CLOSE #5: OPEN inpu$ FOR RANDOM AS #5 LEN = 450
  FIELD #5, 100 AS parm1$, 100 AS parm2$, 100 AS parm3$, 100 AS parm4$

  sc31% = 1 + 4 * (inpnr% - 1)
  GOSUB wrsub
  LSET parm1$ = pa$
  PUT #5, 1
  GOSUB wrsub
  LSET parm2$ = pa$                               'save 4 strings
  PUT #5, 2
  GOSUB wrsub
  LSET parm3$ = pa$
  PUT #5, 3
  GOSUB wrsub
  LSET parm4$ = pa$
  PUT #5, 4
wrfil9:
  CLOSE #5
  CLS
  GOSUB keyset
  RETURN


wrsub:              'save name & parameters for one channel

    IF (par%(sc31%, 14) > 0) THEN GOTO wrsu2               'no parameters ?
    FOR sc32% = 47 TO 79
	par%(sc31%, sc32%) = 0                              'clear values
    NEXT sc32%
    pa$ = CHR$(0)
    FOR sc32% = 1 TO 32
	pa$ = pa$ + CHR$(0) + CHR$(0) + CHR$(0)             'empty parameters
    NEXT sc32%
    GOTO wrsu4
wrsu2:
    in$ = nam$(sc31%)                                       'write name
    IF (in$ = "") THEN in$ = set$ + HEX$(sc31%)
    pa$ = RIGHT$("         " + in$, 8)
    LOCATE 19, 20: PRINT " name :"; in$;
    in% = par%(sc31%, 1)
    IF ((in% < 1) OR (in% > 999)) THEN                     'test channel number
	par%(sc31%, 1) = sc31%                              'set default
	in% = sc31%
    END IF                                                  'write channel number
    pa$ = pa$ + MKI$(in%)
    LOCATE 19, 40: PRINT " nr :"; in%;
    IF (lingu% = 0) THEN
	  LOCATE 16, 2
	  PRINT "                               speichere Regelkreis     :   "; sc31%
    ELSE
	  LOCATE 16, 2
	  PRINT "                              writing channel     :   "; sc31%
    END IF
    LOCATE 20, 2
    FOR sc32% = 3 TO 47
	in% = par%(sc31%, sc32% - 1)                        'write parameters
	pa$ = pa$ + MKI$(in%)
'        PRINT " "; in%;
    NEXT sc32%
wrsu4:
    sc31% = sc31% + 1
    ist% = 0
    timstop! = TIMER + .3
    WHILE (TIMER <= timstop!)                           'delay for next bloc 0.3 sec
    WEND
  RETURN



names:              'config - change channel numbers and/or names
   CLS              'subroutine f-key "config" level 1
   COLOR 7, 1
   scflgk% = 0
   scconfl% = 1                                   ' loop until ready
   scparapg% = 0                                  ' move cursor for names
   KEY OFF                                        ' set keys
   KEY 1, "": KEY 2, "": KEY 3, "": KEY 4, ""
   KEY 5, "": KEY 7, "": KEY 8, "": KEY 10, ""
   KEY(1) OFF: KEY(2) OFF: KEY(3) OFF: KEY(4) OFF: KEY(5) OFF
   KEY(6) ON: KEY(7) OFF: KEY(8) OFF: KEY(9) ON: KEY(10) OFF
   KEY(11) ON: KEY(12) ON: KEY(13) ON: KEY(14) ON           'set cursor keys
 
   pa% = 0                                        'set page 1
   can% = 4 * pa% + 1                             'set first channel on display
   lin% = 2                                       'set cursor first line
   row% = 45                                      'set cursor second row
   GOSUB namset                         'set display with up to 4 controllers

names4:             'set fkt key loops, level 2
     ON KEY(6) GOSUB pgnext                       'next page
'     ON KEY(9) GOSUB scfl9                       'end of configuration
     ON KEY(11) GOSUB curup                       'cursor up
     ON KEY(12) GOSUB curside                     'cursor left
     ON KEY(13) GOSUB curside                     'cursor right
     ON KEY(14) GOSUB curdwn                      'cursor down
     

names5:                                           'test input
     GOSUB curdis                                 'display cursor
     ino$ = ""                                     'clr input buffer
names6:

     ino$ = INKEY$                                           'change ?
     IF ((LEN(ino$) = 2) AND (ASC(LEFT$(ino$, 1)) = 0)) THEN
	ino$ = RIGHT$(ino$, 1)                               'check first cursor bloc
	IF (ino$ = "H") THEN
	   GOSUB curup                                       'cursor up
	ELSEIF (ino$ = "K") THEN GOSUB curside               'cursor to side
	ELSEIF (ino$ = "M") THEN GOSUB curside               'cursor to side
	ELSEIF (ino$ = "P") THEN GOSUB curdwn                'cursor down
	END IF
	ino$ = ""                                            'clr input buffer
     END IF


     IF (ino$ = "") THEN GOTO names9                         'wait
     IF (ino$ <> CHR$(13)) THEN
	COLOR 8, 7
	inpu$ = inpu$ + ino$                                 'input
	LOCATE lin%, row%                                   'display input
	IF (row% = 26) THEN
	    PRINT RIGHT$("        " + inpu$, 5);
	ELSE
	    PRINT RIGHT$("        " + inpu$, 8);
	END IF
	timstop! = TIMER + .5
	WHILE (TIMER <= timstop!)                           'delay for next key 0.5 sec
	WEND
	COLOR 7, 1
	GOTO names6
     ELSE                                                   'cr
	IF (inpu$ = "") THEN GOTO names7          'cursor down without change
	IF (row% = 26) THEN
	    inpu% = VAL(inpu$)                             'number
	    inpu% = ((inpu% - 1) AND (4092)) + 1  'select first number
	    IF (inpu% < -3) THEN inpu% = -3               'test lower limit; default 999 (no conflict with
	    IF (inpu% > 999) THEN inpu% = 999             'test higher limit              existing channels)
	    par%(can%, 1) = inpu%
	    par%(can% + 1, 1) = inpu% + 1
	    par%(can% + 2, 1) = inpu% + 2
	    par%(can% + 3, 1) = inpu% + 3
	    GOSUB namset
	ELSE
	    nam$(can%) = RIGHT$("        " + inpu$, 8)      'name
	END IF
	timstop! = TIMER + .1
	WHILE (TIMER <= timstop!)                           'delay for display 0.1 sec
	WEND
	par%(can%, 14) = 0                                  ' clr tc (2.test for parameter)
	par%(can%, 79) = 0                                  ' clr "D" flg
		 
	inpu$ = "": inpu% = 0
     END IF
names7:
     GOSUB curdis                                           'display input
'     timstop! = TIMER + 0.2
'     WHILE (TIMER <= timstop!)                              'delay for next bloc 0.5 sec
'     WEND
     GOSUB curout                                           'display off
     GOSUB curdwn
     GOTO names5                                            'loop
names9:
     IF (scconfl% <> 0) THEN GOTO names6          'exit or loop
    
     scflgk% = 0                                            'level 2-->1
     scxfl% = 0                                             'clear refresh - flag
     COLOR 7, 1                                             'reset color
     GOSUB keyset                                           'set fkeys level 1
  RETURN



namset:             'set display with up to 4 controllers
   IF (lingu% = 0) THEN GOTO namset2            'goto config in deutsch
     KEY 6, "chan +": KEY 9, "break"
     KEY ON
     FOR sck% = 0 TO 3
	IF 4 * pa% + 1 + sck% > cmax% THEN GOTO namset9

	PRINT "           controller :"; 4 * pa% + 1 + sck%
	PRINT "               channel:  ";
	PRINT USING "#####"; par%(1 + 4 * sck% + 16 * pa%, 1)
	LOCATE 2 + 6 * sck%, 39
	PRINT "name: "; nam$(1 + 4 * sck% + 16 * pa%)
	PRINT "               channel:  ";
	PRINT USING "#####"; par%(2 + 4 * sck% + 16 * pa%, 1)
	LOCATE 3 + 6 * sck%, 39
	PRINT "name: "; nam$(2 + 4 * sck% + 16 * pa%)
	PRINT "               channel:  ";
	PRINT USING "#####"; par%(3 + 4 * sck% + 16 * pa%, 1)
	LOCATE 4 + 6 * sck%, 39
	PRINT "name: "; nam$(3 + 4 * sck% + 16 * pa%)
	PRINT "               channel:  ";
	PRINT USING "#####"; par%(4 + 4 * sck% + 16 * pa%, 1)
	LOCATE 5 + 6 * sck%, 39
	PRINT "name: "; nam$(4 + 4 * sck% + 16 * pa%);
	IF (sck% < 3) THEN PRINT : PRINT
     NEXT sck%
     GOTO namset9
namset2:                                           'config in deutsch
     KEY 6, " nr +": KEY 9, "zurck"
     KEY ON
     FOR sck% = 0 TO 3
	IF 4 * pa% + 1 + sck% > cmax% THEN GOTO namset9

	PRINT "         Gert  :"; 4 * pa% + 1 + sck%
	PRINT "            Regelkreis:  ";
	PRINT USING "#####"; par%(1 + 4 * sck% + 16 * pa%, 1)
	LOCATE 2 + 6 * sck%, 39
	PRINT "name: "; nam$(1 + 4 * sck% + 16 * pa%)
	PRINT "            Regelkreis:  ";
	PRINT USING "#####"; par%(2 + 4 * sck% + 16 * pa%, 1)
	LOCATE 3 + 6 * sck%, 39
	PRINT "name: "; nam$(2 + 4 * sck% + 16 * pa%)
	PRINT "            Regelkreis:  ";
	PRINT USING "#####"; par%(3 + 4 * sck% + 16 * pa%, 1)
	LOCATE 4 + 6 * sck%, 39
	PRINT "name: "; nam$(3 + 4 * sck% + 16 * pa%)
	PRINT "            Regelkreis:  ";
	PRINT USING "#####"; par%(4 + 4 * sck% + 16 * pa%, 1)
	LOCATE 5 + 6 * sck%, 39
	PRINT "name: "; nam$(4 + 4 * sck% + 16 * pa%);
	IF (sck% < 3) THEN PRINT : PRINT
     NEXT sck%
namset9:
  RETURN



pgnext:             ' increment page counter
   CLS
   COLOR 7, 1                                     'default color
   inpu$ = ""                                     'clr input buffer
	pa% = pa% + 1                             'pa% = page counter
	IF pa% > 7 OR (4 * pa% >= cmax%) THEN
	       pa% = 0
	END IF
	can% = 16 * pa% + 1                       'set first channel on display
	lin% = 2                                  'set cursor second line
	row% = 45                                 'set cursor second row
	GOSUB namset                              'set new display
	GOSUB curdis                              'display cursor
   RETURN



ready:              'end of configuration names
     inpu$ = ""                                             'clear string
     RETURN



curup:              'cursor step up
   inpu$ = ""                                     'clr input buffer
   IF (scparapg% = 1) THEN                        ' change parameter
       scparatim! = TIMER                         ' reset refresh timer
       GOSUB curclr                               'clear last cursor position
       IF (lin% <= 7) THEN
	   lin% = 6                               'parma: page 1
       ELSEIF (lin% = 17) THEN lin% = 15          ' free line
       ELSE lin% = lin% - 1
       END IF
       GOSUB curset
   ELSEIF (scparapg% = 2) THEN                    ' change parameter
       scparatim! = TIMER                         ' reset refresh timer
       GOSUB curclr                               'clear last cursor position
       IF (lin% <= 7) THEN lin% = 7 ELSE lin% = lin% - 1
       GOSUB curset                               'param: page 2
   ELSE
       GOSUB curout                                'clear last cursor position
	IF (lin% <= 2) THEN                       'config
	    lin% = 2
	    can% = 16 * pa% + 1                   'set last channel on display
	ELSEIF ((lin% = 8) OR (lin% = 14) OR (lin% = 20)) THEN
	    IF (row% = 45) THEN                  'curup single line with names only
		lin% = lin% - 3
		can% = can% - 1
	    ELSE
		lin% = lin% - 6
		can% = can% - 4
	    END IF
	ELSE
	    IF (row% = 45) THEN                  'curup single line with names only
		lin% = lin% - 1
		can% = can% - 1
	    END IF
	END IF
      GOSUB curdis                              'display cursor
   END IF
  RETURN



curside:            'cursor step aside (left or right cursor)
   GOSUB curout                                   'clear last cursor position
   inpu$ = ""                                     'clr input buffer
	IF (row% = 26) THEN row% = 45 ELSE row% = 26
	IF (row% = 26) THEN
	     lin% = INT((lin% - 2) / 6) * 6 + 2
	     can% = INT((can% - 1) / 4) * 4 + 1
	END IF
	GOSUB curdis                              'display cursor
   RETURN


curdwn:             'cursor step down
   inpu$ = ""                                     'clr input buffer
   IF (scparapg% = 1) THEN
					' change parameter, no interrupt
       scparatim! = TIMER                         ' reset refresh timer
       GOSUB curclr                               'clear last cursor position
       IF (lin% >= 20) THEN
	   lin% = 6                               'param: page 1
       ELSEIF (lin% = 15) THEN lin% = 17          ' free line
       ELSE lin% = lin% + 1
       END IF
       GOSUB curset
   ELSEIF (scparapg% = 2) THEN
					' change parameter, no interrupt
       scparatim! = TIMER                         ' reset refresh timer
       GOSUB curclr                               'clear last cursor position
       IF (lin% >= 9) THEN lin% = 7 ELSE lin% = lin% + 1
       GOSUB curset                               'param: page 2
   ELSE
      GOSUB curout                                'clear last cursor position
      IF (can% >= 4 * cmax%) THEN lin% = 24       'test last channel
      IF (lin% >= 23) THEN                        'config:
	    lin% = 2: can% = 16 * pa% + 1         'set first channel on display
      ELSEIF ((lin% = 5) OR (lin% = 11) OR (lin% = 17)) THEN
	    lin% = lin% + 3: can% = can% + 1
      ELSE
	    IF (row% = 45) THEN                  'curdown single line with names only
	       lin% = lin% + 1: can% = can% + 1
	    ELSE
	       IF ((can% + 4) >= 4 * cmax%) THEN
		lin% = 2: can% = 16 * pa% + 1         'set first channel on display
	       ELSE
		lin% = lin% + 6: can% = can% + 4
	       END IF
	    END IF
      END IF
      GOSUB curdis                                'display cursor
   END IF
  RETURN



curdis:             'display cursor
   COLOR 8, 7
   GOTO curdi

curout:             'clear cursor display
   COLOR 7, 1
curdi:
   LOCATE lin%, row%
   IF (row% = 26) THEN
      PRINT USING "#####"; par%(can%, 1);
   ELSE
      PRINT RIGHT$("        " + nam$(can%), 8);
   END IF
   COLOR 7, 1
   RETURN



lingua:         'select language for  dialog
     lingua2                                              'set big letters

lingua4:
     LOCATE 17, 40
     PRINT "      ";
     LOCATE 17, 40
     ii$ = INKEY$
     IF (ii$ = "") THEN GOTO lingua4                      'wait until input
     IF ((ii$ = "d") OR (ii$ = "D")) THEN
	lingu% = 0
     ELSEIF ((ii$ = "e") OR (ii$ = "E")) THEN
	lingu% = 1
     ELSE
	GOTO lingua4                                      'select lingua deutsch or english
     END IF

     PRINT ii$;

     timstop! = TIMER + 2
     WHILE (TIMER <= timstop!)                              'delay for next bloc 0.5 sec
     WEND
     COLOR 7, 1
  RETURN



paraset:            'set table with address in par$/parametertype
 
    FOR ssi% = 1 TO 18                  'default
      parp%(ssi%, 1) = 0: parp%(ssi%, 2) = 4: parp%(ssi%, 3) = 9999: parp%(ssi%, 4) = 1: parp%(ssi%, 5) = 0
      parv%(ssi%, 1) = 0: parv%(ssi%, 2) = 4: parv%(ssi%, 3) = 1: parv%(ssi%, 4) = 2: parv%(ssi%, 5) = 0
    NEXT ssi%

    parp%(1, 1) = 2: parp%(1, 5) = -999: parp%(2, 1) = 3: parp%(2, 5) = -999
    parp%(3, 1) = 10: parp%(3, 5) = -999: parp%(4, 1) = 11: parp%(4, 5) = -999
    parp%(5, 1) = 15: parp%(6, 1) = 16: parp%(7, 1) = 19: parp%(8, 1) = 18
    parp%(9, 1) = 17: parp%(10, 1) = 14: parp%(10, 5) = 1   'par.%(x, ) = line number from 6 up
    parp%(12, 1) = 24: parp%(12, 3) = 3: parp%(12, 4) = 10  'par.%( ,1) = parameter number in par$(),par%(,);  0 = empty line
    parp%(13, 1) = 29: parp%(13, 3) = 1: parp%(13, 4) = 4   'par.%( ,2) = number of channels: 4 or 1 = common
    parp%(14, 1) = 32: parp%(14, 3) = 1: parp%(14, 4) = 6   'par.%( ,3) = upper limit for parameter 0/1/4/...
    parp%(15, 1) = 33: parp%(15, 3) = 1: parp%(15, 4) = 8   'par.%( ,4) = offset in sctxt$() + 1
    parp%(17, 1) = 79: parp%(17, 3) = 99                    'par.%( ,5) = lower limit for parameters
    parv%(2, 1) = 41: parv%(2, 2) = 1: parv%(2, 4) = 1
    parv%(3, 1) = 39: parv%(3, 2) = 1                       'par.%(,) = parp%(,) or parv%(,)
    parv%(4, 1) = 38: parv%(4, 2) = 1
    parv%(6, 1) = 47: parv%(7, 1) = 48: parv%(8, 1) = 49
    parv%(16, 1) = 53: parv%(16, 2) = 4
    parv%(17, 1) = 68: parv%(17, 2) = 4

    DATA ,SP 1,2,SP 2,3,SP L,4,SP H,5,rn L,8,rn H,9,AL L,10,AL H,11,Y SE,12,Y hd,13,  tc,14,Pb I,15
    DATA PbII,16,  ti,17,  td,18,dbnd,19,Ydry,20,Edry,21,CHAn,24,PtYP,25,unit,26,dPnt,27,YtYP,28, oPt,29
    DATA d SE,30, dir,31, out,32,  AL,33, YAs,34, dry,35, out,38, oPt,39,  rn,40,  CJ,41
 
 
  RETURN

tablec:
		'table with comment to parameters and values set
		' place "n" in array par$(n) is the same as in par%( ,n)

IF (lingu% = 0) THEN GOTO tablec2                 'goto table in deutsch
	       
		'table in english
				      'set default channel names
	FOR sci1% = 1 TO 4 * cmax%                ' for bargraph
	   nam$(sci1%) = RIGHT$("  zone  " + HEX$(sci1%), 8)
	NEXT sci1%

sctxt$(1) = "      on"        'set text table for param. flags
sctxt$(2) = "     off"
sctxt$(3) = "      on"
sctxt$(4) = " disable"
sctxt$(5) = "  enable"
sctxt$(6) = "  normal"
sctxt$(7) = " inverse"
sctxt$(8) = "relative"
sctxt$(9) = "absolute"
sctxt$(10) = " control"
sctxt$(11) = "lim.comp"
sctxt$(12) = " measure"
sctxt$(13) = "     off"
sctxt$(14) = "   ERROR"
	       
		' signed integer parameters   30 tabs comment
par$(1) = "channel                 nr     "                 'No = logical number of channel
par$(2) = "setpoint 1              SP 1   "                 '" W " = setpoint 1
par$(3) = "setpoint 2              SP 2   "                 '        setpoint 2
par$(4) = "setpoint limit low      SP L   "                 'setpoint limit low
par$(5) = "setpoint limit high     SP H   "                 'setpoint limit high
par$(6) = " "
par$(7) = " "
par$(8) = "range limit low/offset  rn L/o "                 'range for process variable limit low/offset
par$(9) = "range limit high        rn H   "                 'range for process variable limit high
par$(10) = "alarm  low              AL L   "                'limit comparator for process variable low limit
par$(11) = "alarm  high             AL H   "                'limit comparator for process variable high limit
par$(12) = "output on sensor error  Y SE   "                'Yse = ton/(ton+toff) on sensor error
par$(13) = " "
par$(14) = "cycle time              tc     "                'cycle time for measurement & output switch
par$(15) = "proportional band       Pb I   "
par$(16) = "prop.band/regul.time  Pb II/tY "                'proportional band II/step time tY with step output
par$(17) = "integral time           ti     "
par$(18) = "derivative time         td     "
par$(19) = "dead band               dbnd   "
par$(20) = " "
par$(21) = " "
par$(22) = " "
par$(23) = " "

		'unsigned char parameters
par$(24) = "channel mode            CHAn   "                ' 0 = on:controller; 1 = Pro:limit comp.; 2 = AL:measure only; 4 = off
par$(25) = "process type            PtYP   "                ' 0 = F SP:standart; bit1: H = diff. of 2 inputs; bit2: H = SLA:ext.SP
par$(26) = "unit                    unit   "                'dimension: bit 0,1,2 = Cel,Fahr,sec
par$(27) = "decimal point           dPnt   "                'decimal point: 0 = no; bit 1,2,3 = 1.,2.,3. places from right
par$(28) = "output type             YtYP   "                'switching output: 0 = normal; 1 = step
par$(29) = "self tuning             oPt    "                'one time on SP step: 0 = disable; 1 = enable
par$(30) = "outp.dir. on sens.err.  d SE   "                'reaction outputs : 0 = like X >> SP; 1 = like X << SP
par$(31) = "deviation direction     dir    "                'dev.direct. & hysteresis: 0 = normal; 1 = inverse
par$(32) = "output direction        out    "                ' 0 = normal; 1 = inverse
par$(33) = "alarm  mode             AL     "                ' 0 = relative to SP; 1 = absolute on process variable
par$(34) = " "
par$(35) = " "
par$(36) = " "

		'unsigned char parameters, common parameters for all channels of one controller
par$(37) = " "
par$(38) = "outputs                 out    "                ' 0 = all outputs off; 1 = on
par$(39) = "self tuning start       oPt    "                ' 0 = switch off; 1 = switch on
par$(40) = "range 1/2               rn     "                ' 0 = sensor type J,K,S,2Ltr,0..20mA; 1 = L,K,3Ltr,4..20mA
par$(41) = "cold junction off       CJ     "                ' 0 = on; 1 = 0 oC (only with TC inputs )
par$(42) = " "
par$(43) = " "
par$(44) = " "
par$(45) = " "
par$(46) = " "
 
		' signed integer values
par$(47) = "process variable        X      "                ' X         (oC, oF, units)
par$(48) = "deviation               xw     "                ' xw = X - W (process range * 0x4000)
par$(49) = "output                  y      "                ' Y = ton/(ton+toff) * 0x4000
par$(50) = " "
par$(51) = " "

		' unsigned char values
par$(52) = "status self tuning             "                ' 0 = end; 1..8 = running; 16 = break
par$(53) = "output signal                  "                ' bit 5..0 on = I on; II on; AL L on; AL H on; sensor error
par$(54) = " "
par$(55) = " "

		'unsigned char values, common for all channels of one controller
par$(56) = "clock                          "                ' clock counts from 0..63 * 0.2 sec relative to startup
par$(57) = " "
par$(58) = " "
par$(59) = " "
par$(60) = " "
par$(61) = " "
par$(62) = " "               ' identification B bit 4..0
par$(63) = " "
par$(64) = " "
par$(65) = " "
par$(66) = " "
par$(67) = " "
par$(68) = "heating current                "                ' 0 = ok; 1 = error
par$(76) = " "               'flag for valid decimal point 0 ... 3.position from right
par$(79) = "status array par%( , )         "                ' 0,"?","A","D" means no parameter pa,ask for pa.,changed pa.,pa. o.k.
GOTO tablec4

tablec2:
				      'set default channel names
	FOR sci1% = 1 TO 4 * cmax%                ' for bargraph
	   nam$(sci1%) = RIGHT$("  zone  " + HEX$(sci1%), 8)
	NEXT sci1%

sctxt$(1) = "     ein"        'set text table for param. flags
sctxt$(2) = "     aus"
sctxt$(3) = "     ein"
sctxt$(4) = "gesperrt"
sctxt$(5) = "    frei"
sctxt$(6) = "  normal"
sctxt$(7) = "  invers"
sctxt$(8) = " relativ"
sctxt$(9) = " absolut"
sctxt$(10) = "  Regler"
sctxt$(11) = "Grenzsig"
sctxt$(12) = "  messen"
sctxt$(13) = "     aus"
sctxt$(14) = "  FEHLER"
	       
		' signed integer parameters   30 tabs comment
par$(1) = "Regelkreisnummer        nr     "                 'No = logical number of channel
par$(2) = "Sollwert 1              SP 1   "                 '" W " = setpoint 1
par$(3) = "Sollwert 2              SP 2   "                 '        setpoint 2
par$(4) = "Sollw. untere Grenze    SP L   "                 'setpoint limit low
par$(5) = "Sollw. obere  Grenze    SP H   "                 'setpoint limit high
par$(6) = " "
par$(7) = " "
par$(8) = "Messber.unt.Gr./Offs.   rn L/o "                 'range for process variable limit low/offset
par$(9) = "Messber.ob. Grenze      rn H   "                 'range for process variable limit high
par$(10) = "unterer Grenzwert       AL L   "                'limit comparator for process variable low limit
par$(11) = "oberer  Grenzwert       AL H   "                'limit comparator for process variable high limit
par$(12) = "Stellgrd bei Fhl.Fehl  Y SE   "                'Yse = ton/(ton+toff) on sensor error
par$(13) = " "
par$(14) = "Zykluszeit              tc     "                'cycle time for measurement & output switch
par$(15) = "Proportionalband        Pb I   "
par$(16) = "Propbd./Stellzeit      Pb II/tY"                'proportional band II/step time tY with step output
par$(17) = "Nachstellzeit           ti     "
par$(18) = "Vorhaltezeit            td     "
par$(19) = "Totzone                 dbnd   "
par$(20) = " "
par$(21) = " "
par$(22) = " "
par$(23) = " "

		'unsigned char parameters
par$(24) = "Reglermodus             CHAn   "                ' 0 = on:controller; 1 = Pro:limit comp.; 2 = AL:measure only; 4 = off
par$(25) = "Reglertyp               PtYP   "                ' 0 = F SP:standart; bit1: H = diff. of 2 inputs; bit2: H = SLA:ext.SP
par$(26) = "Dimension               unit   "                'dimension: bit 0,1,2 = Cel,Fahr,sec
par$(27) = "Dezimalpunkt            dPnt   "                'decimal point: 0 = no; bit 1,2,3 = 1.,2.,3. places from right
par$(28) = "Ausgang                 YtYP   "                'switching output: 0 = normal; 1 = step
par$(29) = "Optimierung             oPt    "                'one time on SP step: 0 = disable; 1 = enable
par$(30) = "Ausgnge bei Fhl.Fehl. d SE   "                'reaction outputs : 0 = like X >> SP; 1 = like X << SP
par$(31) = "Wirk.richt.der Regelabw.dir    "                'dev.direct. & hysteresis: 0 = normal; 1 = inverse
par$(32) = "Wirkungsricht.Ausgnge  out    "                ' 0 = normal; 1 = inverse
par$(33) = "Grenzwertmodus          AL     "                ' 0 = relative to SP; 1 = absolute on process variable
par$(34) = " "
par$(35) = " "
par$(36) = " "

		'unsigned char parameters, common parameters for all channels of one controller
par$(37) = " "
par$(38) = "Ausgnge                out    "                ' 0 = all outputs off; 1 = on
par$(39) = "Optimierung Start       oPt    "                ' 0 = switch off; 1 = switch on
par$(40) = "Messbereich 1/2         rn     "                ' 0 = sensor type J,K,S,2Ltr,0..20mA; 1 = L,K,3Ltr,4..20mA
par$(41) = "Vergleichsstelle        CJ     "                ' 0 = on; 1 = 0 oC (only with TC inputs )
par$(42) = " "
par$(43) = " "
par$(44) = " "
par$(45) = " "
par$(46) = " "

		' signed integer values
par$(47) = "Regelgrsse             X      "                ' X         (oC, oF, units)
par$(48) = "Regelabweichung         xw     "                ' xw = X - W (process range * 0x4000)
par$(49) = "Stellgrad               y      "                ' Y = ton/(ton+toff) * 0x4000
par$(50) = " "
par$(51) = " "

		' unsigned char values
par$(52) = "Optimierung Status             "                ' 0 = end; 1..8 = running; 16 = break
par$(53) = "Ausgangssignale                "                ' bit 5..0 on = I on; II on; AL L on; AL H on; sensor error
par$(54) = " "
par$(55) = " "

		'unsigned char values, common for all channels of one controller
par$(56) = "Uhr                            "                ' clock counts from 0..63 * 0.2 sec relative to startup
par$(57) = " "
par$(58) = " "
par$(59) = " "
par$(60) = " "
par$(61) = " "
par$(62) = " "               ' identification B bit 4..0
par$(63) = " "
par$(64) = " "
par$(65) = " "
par$(66) = " "
par$(67) = " "
par$(68) = "Heizstromfehler                "                ' 0 = ok; 1 = error
par$(76) = " "               'flag for valid decimal point 0 ... 3.position from right
par$(79) = "Status Feld par%( , )          "                ' 0,"?","A","D" = keine parameter pa,frage nach pa.,gend.pa.,pa. i.O

tablec4:
  RETURN

  END

SUB examples



'example 1: ask for new values of channels
'
'  all controllers will be asked automatically by interrupt programm scloop
'


'example 2: ask for new parameters of channel 7 from interface bus
'
'  line-number sc22% of arrays par$() and par%(,sc22%) may be different from channel number par%( ,1) !!!
'
'      scnreg% =  7                                ' set line-number (equal channel-number for this case)
'      par%(scnreg%,79) = 63                       ' set "?" - flag
'                                                  ' thats all, because interrupt routine scloop test flags automatically


'example 3: change parameter(s)  of channel 19
'
'  While changing parameters via interface-bus and controller keys at the same time last input will be valid, so
'  its a good practice asking for new parameters before changing and output the changed parameters.
'  Are only some controllers on interface-bus, the automatic parameter input will be fast enough.
'  Because the dialogue distance sczeit% =1sec (XT: =2sec), the parameter input time with 5 controllers
'   is    sczeit% * 4 * 3 *(5 + 1) sec.
'
'      scnreg% = 19
'      par%(scnreg%,79) = 63                       '"?" flag; ask for new parameters; 8 channels will
'                                                  '    be testet for this flag on each sczeit%
'
'      job                                         'job or wait at min.  sczeit% * (max.channel number/8 +1)sec
'
'      scopreg% = 19
'      par%(scopreg%,2)  = par%(scopreg%,2) + 5    'increment setpoint 1 by 5
'      par%(scopreg%,11) = 15                      'set alarm high at 15 relative setpoint
'      par%(scopreg%,14) = 3                       'set output cycle time at 3 sec
'
'      par%(scopreg%,79) = 65                      '"A" flag; output parameters to interface bus
'
'
'      sc33% = 4*INT((scopreg%-1)/4) + 1                     'first channel of a controller
'                                                  'Changing a parameter which is common for a controller,
'      FOR ii% = sc33% TO sc33% + 3                ' it is necessary to change the parameter at all
'         par%(scopreg%,38) = 1                    ' channels with this controller.
'      NEXT ii%                                    'set outputs on
'
'      par%(scopreg%,79) = 65                      'Because common parameters for this 4 channels are the same
'                                                  ' the output of one of them to interface-bus will do the job.
'      job                                         'job or wait at min.  sczeit% * (max.channel number/8 +1)sec
'



END SUB

SUB lingua2       'select language for  dialog
     CLS
     COLOR 10, 1
     LOCATE 8, 4
     PRINT " ķ ";                                       'print question
     LOCATE 9, 4
     PRINT "     ";
     LOCATE 10, 4
     PRINT " Ľ ";
     LOCATE 8, 46
     PRINT "  ";
     LOCATE 9, 46
     PRINT "    ";
     LOCATE 10, 46
     PRINT "  ";
     COLOR 7, 1
     LOCATE 9, 41
     PRINT "OR"
     LOCATE 8, 11
     PRINT "           ";
     LOCATE 9, 11
     PRINT "         ķ    ͹ ";
     LOCATE 10, 11
     PRINT "     Ľ     ";
     LOCATE 8, 50
     PRINT " ֿ ķ         ";
     LOCATE 9, 50
     PRINT "   ķ     ķ ͹ ";
     LOCATE 10, 50
     PRINT "  Ľ   Ľ    ";
     COLOR 7, 1
     LOCATE 17, 25
     PRINT " input :      ";
END SUB

SUB logo
'logo:               'company & order no.
     COLOR 4, 1, 1
     SCREEN 0
     CLS
     PRINT
     PRINT "                                        "
     PRINT "                                    "
     PRINT "                                "
     PRINT "                                "
     PRINT "                                "
     PRINT "                                  "
     PRINT "                            "
     PRINT "                        "
     PRINT "                      "
     PRINT "                    "
     PRINT "                            "
     PRINT "                              "
     PRINT
     PRINT
     PRINT "        ͻ ͻ  ͻ   ɻ  ɻ  ͻ    ֿ   ɻ  ͻ    ɻ  "
     PRINT "        ͹ ͻ   ͹   ׽ ׽         ׽       ׽ "
     PRINT "          ͼ      ͼ   ͼ ͼ    ͼ ͼ ͼ    "
     COLOR 15, 1
     PRINT "                          M e t r a w a t t   G m b H "
     COLOR 7, 1
     PRINT
     PRINT
     PRINT "        GTR 300 DEMO - Programm      sc300   'BD'   "
     PRINT "        Schnittstelle zu PC          "
     PRINT "                                                     Best. Nr.:  GTZ4801";
    
     timstop! = TIMER + 5
     WHILE (TIMER <= timstop!)                               'delay for display 5 sec
     WEND
     COLOR 7, 1

END SUB

